/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.navigator.imports;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.smartmdsd.navigator.imports.ImportedProjectsElement;
import org.eclipse.smartmdsd.ui.factories.JavaProjectFactory;
import org.eclipse.smartmdsd.ui.wizards.SmartMDSDFilteredProjectImportContentProvider;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ManageProjectImportsCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IProject selectedProject = this.getSelectedProject(window);
        if (selectedProject != null) {
            List<IProject> preselectedProjects = null;
            try {
                preselectedProjects = Arrays.asList(selectedProject.getReferencedProjects());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            WorkbenchLabelProvider workbencLbelProvider = new WorkbenchLabelProvider();
            String dialogTitle = "Imported Projects Selection";
            String dialogMessage = "Select project-references";
            SmartMDSDFilteredProjectImportContentProvider filteredContentProvider = new SmartMDSDFilteredProjectImportContentProvider(selectedProject);
            ListSelectionDialog dialog = new ListSelectionDialog(window.getShell(), (Object)workspaceRoot, (IStructuredContentProvider)filteredContentProvider, (ILabelProvider)workbencLbelProvider, dialogMessage);
            dialog.setTitle(dialogTitle);
            if (preselectedProjects != null) {
                dialog.setInitialElementSelections(preselectedProjects);
            }
            if (dialog.open() == 0) {
                this.updateProjectReferences(selectedProject, dialog.getResult());
            }
        }
        return null;
    }

    private IProject getSelectedProject(IWorkbenchWindow window) {
        ISelection selection = window.getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            IDDiagramEditPart diagramEditPart;
            Option diagramOption;
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof IProject) {
                return (IProject)firstElement;
            }
            if (firstElement instanceof ImportedProjectsElement) {
                ImportedProjectsElement imports = (ImportedProjectsElement)firstElement;
                return imports.getParent();
            }
            if (firstElement instanceof IDDiagramEditPart && (diagramOption = (diagramEditPart = (IDDiagramEditPart)firstElement).resolveDDiagram()).some()) {
                DDiagram diagram = (DDiagram)diagramOption.get();
                String diagramProjectName = diagram.eResource().getURI().segment(1);
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                return workspaceRoot.getProject(diagramProjectName);
            }
        }
        return null;
    }

    private void updateProjectReferences(final IProject currentProject, final Object[] selectedElements) {
        WorkspaceJob job = new WorkspaceJob("Update project settings of " + currentProject.getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IProjectDescription currentDescription = currentProject.getDescription();
                currentDescription.setReferencedProjects((IProject[])Arrays.copyOf(selectedElements, selectedElements.length, IProject[].class));
                currentProject.setDescription(currentDescription, monitor);
                JavaProjectFactory.updateJavaReferencedProjects((IProject)currentProject, (Object[])selectedElements, (IProgressMonitor)monitor);
                currentProject.refreshLocal(2, monitor);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

