/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Vineet Nagrath, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtend.open62541.compiler;

import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaXmlParser;

@SuppressWarnings("all")
public interface OpcUaClient {
  String getOpcUa_DeviceClient_HeaderFileName(final String clientName);
  
  String getOpcUa_DeviceClient_SourceFileName(final String clientName);
  
  String getOpcUa_DeviceClient_TestMain_SourceFileName(final String clientName);
  
  CharSequence compileOpcUa_DeviceClient_HeaderFileContent(final String objectName, final Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList, final Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList);
  
  CharSequence compileOpcUa_DeviceClient_SourceFileContent(final String objectName, final Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList, final Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList);
  
  CharSequence compileOpcUa_DeviceClient_TestMain_SourceFileContent(final String objectName, final Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList, final Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList);
  
  CharSequence compileOpcUa_DeviceClient_Test_CMakeListsContent(final String objectName);
}
