/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Vineet Nagrath, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtend.open62541.compiler;

import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaXmlParser;

@SuppressWarnings("all")
public interface SpecificModelViewController {
  String getSpecificDriverModelHeader(final String name);
  
  String getSpecificViewHeader(final String name);
  
  String getSpecificViewSource(final String name);
  
  String getSpecificControllerHeader(final String name);
  
  String getSpecificControllerSource(final String name);
  
  String getSpecificTestServer(final String name);
  
  CharSequence compileSpecificDriverModelHeader(final String name);
  
  CharSequence compileSpecificViewHeader(final String name);
  
  CharSequence compileSpecificViewSource(final String name);
  
  CharSequence compileSpecificControllerHeader(final String name, final Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList, final Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList);
  
  CharSequence compileSpecificControllerSource(final String name, final Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList, final Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList);
  
  CharSequence compileSpecificTestServer(final String name);
  
  CharSequence compileSpecificCMakeLists(final String name);
}
