/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.system.datasheetPropertyChecks.validation;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smartmdsd.datasheet.indexer.DatasheetProjectSettings;
import org.eclipse.smartmdsd.datasheet.indexer.WorkspaceDatasheetIndexer;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.DefaultDatasheetProperties;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.SystemComponentArchitecture;
import org.eclipse.smartmdsd.ecore.system.datasheetPropertyChecks.DatasheetPropertyCheck;
import org.eclipse.smartmdsd.ecore.system.datasheetPropertyChecks.EvaluationOperator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.osgi.service.prefs.Preferences;

public class DatasheetPropertyCheckEvaluator {
    public Collection<String> getMainPropertyValues(String componentName, String propertyName) {
        WorkspaceDatasheetIndexer indexer = WorkspaceDatasheetIndexer.getInstance();
        DatasheetProjectSettings component_datasheet = indexer.getDatasheetProjectSettings(componentName);
        Preferences property_node = component_datasheet.getMainPropertyNode(propertyName);
        return component_datasheet.getPropertyValues(property_node);
    }

    public Collection<String> getIncompatiblePropertyValues(ComponentInstance instance, DatasheetPropertyCheck check) {
        ArrayList result = CollectionLiterals.newArrayList();
        boolean _equals = check.getPropertyName().equals(DefaultDatasheetProperties.TECHNOLOGY_READINESS_LEVEL.getLiteral());
        if (_equals) {
            int right_value = this.getTRLIndex(check.getPropertyValue());
            Collection<String> _mainPropertyValues = this.getMainPropertyValues(instance.getComponent().getName(), check.getPropertyName());
            for (String value : _mainPropertyValues) {
                boolean _not;
                int left_value = this.getTRLIndex(value);
                boolean _intCompare = this.intCompare(left_value, check.getOperator(), right_value);
                boolean bl = _not = !_intCompare;
                if (!_not) continue;
                result.add(value);
            }
        } else {
            Collection<String> _mainPropertyValues_1 = this.getMainPropertyValues(instance.getComponent().getName(), check.getPropertyName());
            for (String value_1 : _mainPropertyValues_1) {
                boolean _not;
                boolean _stringCompare = this.stringCompare(value_1, check.getOperator(), check.getPropertyValue());
                boolean bl = _not = !_stringCompare;
                if (!_not) continue;
                result.add(value_1);
            }
        }
        return result;
    }

    public boolean exists(SystemComponentArchitecture system, DatasheetPropertyCheck check) {
        boolean _equals = check.getPropertyName().equals(DefaultDatasheetProperties.TECHNOLOGY_READINESS_LEVEL.getLiteral());
        if (_equals) {
            int right_value = this.getTRLIndex(check.getPropertyValue());
            EList _components = system.getComponents();
            for (ComponentInstance instance : _components) {
                Collection<String> _mainPropertyValues = this.getMainPropertyValues(instance.getComponent().getName(), check.getPropertyName());
                for (String value : _mainPropertyValues) {
                    int left_value = this.getTRLIndex(value);
                    boolean _intCompare = this.intCompare(left_value, check.getOperator(), right_value);
                    if (!_intCompare) continue;
                    return true;
                }
            }
        } else {
            EList _components_1 = system.getComponents();
            for (ComponentInstance instance_1 : _components_1) {
                Collection<String> _mainPropertyValues_1 = this.getMainPropertyValues(instance_1.getComponent().getName(), check.getPropertyName());
                for (String value_1 : _mainPropertyValues_1) {
                    boolean _stringCompare = this.stringCompare(value_1, check.getOperator(), check.getPropertyValue());
                    if (!_stringCompare) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public int getTRLIndex(String value) {
        try {
            int _length = value.length();
            int _minus = _length - 1;
            return Integer.valueOf(value.substring(_minus));
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                return 0;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public double calculateSum(SystemComponentArchitecture system, String propertyName) throws NumberFormatException {
        double sum = 0.0;
        WorkspaceDatasheetIndexer indexer = WorkspaceDatasheetIndexer.getInstance();
        EList _components = system.getComponents();
        for (ComponentInstance instance : _components) {
            DatasheetProjectSettings component_datasheet = indexer.getDatasheetProjectSettings(instance.getComponent().getName());
            if (component_datasheet == null) continue;
            Preferences property_node = component_datasheet.getMainPropertyNode(propertyName);
            Collection _propertyValues = component_datasheet.getPropertyValues(property_node);
            for (String value : _propertyValues) {
                double _sum = sum;
                Double _valueOf = Double.valueOf(value);
                sum = _sum + _valueOf;
            }
        }
        return sum;
    }

    public boolean stringCompare(String left, EvaluationOperator op, String right) {
        boolean _switchResult = false;
        if (op != null) {
            switch (op) {
                case EQ: {
                    _switchResult = Objects.equal((Object)left, (Object)right);
                    break;
                }
                case NEQ: {
                    _switchResult = !Objects.equal((Object)left, (Object)right);
                    break;
                }
                case LT: {
                    _switchResult = left.compareTo(right) < 0;
                    break;
                }
                case LET: {
                    _switchResult = left.compareTo(right) <= 0;
                    break;
                }
                case GET: {
                    _switchResult = left.compareTo(right) >= 0;
                    break;
                }
                case GT: {
                    _switchResult = left.compareTo(right) > 0;
                    break;
                }
                default: {
                    _switchResult = false;
                    break;
                }
            }
        } else {
            _switchResult = false;
        }
        return _switchResult;
    }

    public boolean intCompare(int left, EvaluationOperator op, int right) {
        boolean _switchResult = false;
        if (op != null) {
            switch (op) {
                case EQ: {
                    _switchResult = left == right;
                    break;
                }
                case NEQ: {
                    _switchResult = left != right;
                    break;
                }
                case LT: {
                    _switchResult = left < right;
                    break;
                }
                case LET: {
                    _switchResult = left <= right;
                    break;
                }
                case GET: {
                    _switchResult = left >= right;
                    break;
                }
                case GT: {
                    _switchResult = left > right;
                    break;
                }
                default: {
                    _switchResult = false;
                    break;
                }
            }
        } else {
            _switchResult = false;
        }
        return _switchResult;
    }

    public boolean doubleCompare(double left, EvaluationOperator op, double right) {
        boolean _switchResult = false;
        if (op != null) {
            switch (op) {
                case EQ: {
                    _switchResult = left == right;
                    break;
                }
                case NEQ: {
                    _switchResult = left != right;
                    break;
                }
                case LT: {
                    _switchResult = left < right;
                    break;
                }
                case LET: {
                    _switchResult = left <= right;
                    break;
                }
                case GET: {
                    _switchResult = left >= right;
                    break;
                }
                case GT: {
                    _switchResult = left > right;
                    break;
                }
                default: {
                    _switchResult = false;
                    break;
                }
            }
        } else {
            _switchResult = false;
        }
        return _switchResult;
    }
}

