/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.sirius.utils.xtext;

import com.google.inject.Injector;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.smartmdsd.sirius.utils.xtext.XtextVirtualResourceProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;

public abstract class AbstractXtextEditorViewPart
extends ViewPart
implements ISaveablePart {
    public static final String ID = "org.eclipse.smartmdsd.sirius.tools.XtextEditorViewPart";
    private boolean dirtyFlag;
    private Composite container = null;
    private XtextVirtualResourceProvider resourceProvider = null;
    private EmbeddedEditorFactory factory = null;
    private EmbeddedEditor editor = null;
    private EmbeddedEditorModelAccess modelAccess = null;
    private IDocumentListener documentListener = null;
    private ISelectionListener selectionListener = null;

    public abstract Injector getInjector();

    public String getModelFileExtension() {
        if (this.resourceProvider != null) {
            return this.resourceProvider.getModelFileExtension();
        }
        return "";
    }

    public void setEmfModelBase(DRepresentationElement diagramElementObject) {
        this.resourceProvider.setCurrentResourceObject(diagramElementObject);
        this.reloadCurrentModelText();
        this.showEmbeddedEditor();
        this.setEditorFocus();
    }

    public void setExternalEmfBase(DRepresentationElement diagramElementObject, URI xtextResourceUri) {
        this.resourceProvider.setExternalResource(diagramElementObject, xtextResourceUri);
        this.reloadCurrentModelText();
        this.showEmbeddedEditor();
        this.setEditorFocus();
    }

    public URI getAccordingXtextResourceUri(DRepresentationElement diagramElementObject) {
        return this.resourceProvider.getAccordingXtextResourceUri(diagramElementObject);
    }

    public void removeResourceBase(URI resourceUri) {
        this.resourceProvider.removeExternalResource(resourceUri);
        this.hideEmbeddedEditor();
    }

    protected void saveModel(IProgressMonitor monitor) {
        if (this.editor != null) {
            this.resourceProvider.saveOriginalResource(monitor);
        }
    }

    public void hideEmbeddedEditor() {
        if (this.editor != null) {
            this.editor.getViewer().getControl().setVisible(false);
        }
    }

    protected void setDirty(boolean dirty) {
        if (this.dirtyFlag != dirty) {
            this.dirtyFlag = dirty;
            this.firePropertyChange(257);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.saveModel(monitor);
        this.setDirty(false);
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    protected XtextVirtualResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public void createPartControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout());
        this.container.setLayoutData((Object)new GridData(4, 4, true, true));
        Injector injector = this.getInjector();
        this.resourceProvider = (XtextVirtualResourceProvider)injector.getInstance(XtextVirtualResourceProvider.class);
        this.factory = (EmbeddedEditorFactory)injector.getInstance(EmbeddedEditorFactory.class);
        this.editor = this.factory.newEditor((IEditedResourceProvider)this.resourceProvider).showErrorAndWarningAnnotations().withParent(this.container);
        this.modelAccess = this.editor.createPartialEditor(true);
        this.addDocumentListener();
        this.setDirty(false);
        this.hideEmbeddedEditor();
        this.addSelectionListener();
    }

    protected void showEmbeddedEditor() {
        if (this.editor != null) {
            this.editor.getViewer().getControl().setVisible(true);
        }
    }

    protected void reloadCurrentModelText() {
        List<String> modelText = this.resourceProvider.getModelText();
        if (modelText.size() == 3) {
            this.modelAccess.updateModel(modelText.get(0), modelText.get(1), modelText.get(2));
            this.setDirty(false);
        }
    }

    protected void addDocumentListener() {
        this.documentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                AbstractXtextEditorViewPart.this.setDirty(true);
            }
        };
        this.editor.getDocument().addDocumentListener(this.documentListener);
    }

    protected void removeDocumentListener() {
        if (this.documentListener != null && this.editor != null) {
            this.editor.getDocument().removeDocumentListener(this.documentListener);
            this.documentListener = null;
        }
    }

    public void setFocus() {
    }

    protected void setEditorFocus() {
        if (this.editor != null) {
            this.editor.getViewer().getControl().setFocus();
        }
    }

    public void dispose() {
        this.removeDocumentListener();
        this.removeSelectionListener();
        super.dispose();
    }

    protected ISelectionListener createNewSelectionListener() {
        return new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                DDiagramEditor dEditor;
                if (part instanceof DDiagramEditor && AbstractXtextEditorViewPart.this.resourceProvider.isCurrentSession((dEditor = (DDiagramEditor)part).getSession())) {
                    AbstractXtextEditorViewPart.this.showEmbeddedEditor();
                    return;
                }
                AbstractXtextEditorViewPart.this.hideEmbeddedEditor();
            }
        };
    }

    protected void addSelectionListener() {
        this.selectionListener = this.createNewSelectionListener();
        this.getSite().getPage().addSelectionListener(this.selectionListener);
    }

    protected void removeSelectionListener() {
        if (this.selectionListener != null) {
            this.getSite().getPage().removeSelectionListener(this.selectionListener);
            this.selectionListener = null;
        }
    }
}

