/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.natures;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.smartmdsd.ui.natures.AbstractSmartMDSDNature;
import org.eclipse.smartmdsd.ui.natures.SmartMDSDNatureEnum;

public class SmartMDSDNatureHelpers {
    public static AbstractSmartMDSDNature getFirstSmartMDSDNatureFrom(IProject project) {
        SmartMDSDNatureEnum[] smartMDSDNatureEnumArray = SmartMDSDNatureEnum.values();
        int n = smartMDSDNatureEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            SmartMDSDNatureEnum natureEnum = smartMDSDNatureEnumArray[n2];
            try {
                if (project.hasNature(natureEnum.getId())) {
                    return natureEnum.getSmartMDSDNatureFrom(project);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return null;
    }

    public static void addProjectNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] currNatures = description.getNatureIds();
        HashSet<String> natureSet = new HashSet<String>();
        natureSet.addAll(Arrays.asList(currNatures));
        natureSet.add(natureId);
        String[] combinedNatures = natureSet.toArray(new String[natureSet.size()]);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateNatureSet(combinedNatures);
        if (status.getCode() == 0) {
            description.setNatureIds(combinedNatures);
            project.setDescription(description, monitor);
        }
    }

    public static void removeProjectNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] currNatures = description.getNatureIds();
        int i = 0;
        while (i < currNatures.length) {
            if (natureId.equals(currNatures[i])) {
                String[] newNatures = new String[currNatures.length - 1];
                System.arraycopy(currNatures, 0, newNatures, 0, i);
                System.arraycopy(currNatures, i + 1, newNatures, i, currNatures.length - i - 1);
                description.setNatureIds(newNatures);
                project.setDescription(description, monitor);
                break;
            }
            ++i;
        }
    }
}

