/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.parameterDefinition.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.InlineEnumerationType;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParamDefModel;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParamDefRepoImport;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterDefinitionPackage;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterSetDefinition;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterSetRepository;
import org.eclipse.smartmdsd.xtext.base.basicAttributes.formatting2.BasicAttributesFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class ParameterDefinitionFormatter extends BasicAttributesFormatter {
  protected void _format(final ParamDefModel paramDefModel, @Extension final IFormattableDocument document) {
    EList<ParamDefRepoImport> _imports = paramDefModel.getImports();
    for (final ParamDefRepoImport import_ : _imports) {
      {
        document.<ParamDefRepoImport>format(import_);
        final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
          it.newLine();
        };
        document.<ParamDefRepoImport>append(import_, _function);
      }
    }
    ParameterSetRepository _repository = paramDefModel.getRepository();
    if (_repository!=null) {
      document.<ParameterSetRepository>format(_repository);
    }
  }
  
  protected void _format(final ParameterSetRepository parameterSetRepository, @Extension final IFormattableDocument document) {
    final ISemanticRegion ropen = this.textRegionExtensions.regionFor(parameterSetRepository).keyword("{");
    final ISemanticRegion rclose = this.textRegionExtensions.regionFor(parameterSetRepository).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(ropen, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(ropen, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(ropen, rclose, _function_2);
    EList<ParameterSetDefinition> _sets = parameterSetRepository.getSets();
    for (final ParameterSetDefinition parameterSetDefinition : _sets) {
      {
        document.<ParameterSetDefinition>format(parameterSetDefinition);
        final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
          it.oneSpace();
        };
        document.surround(this.textRegionExtensions.regionFor(parameterSetDefinition).feature(ParameterDefinitionPackage.Literals.PARAMETER_SET_DEFINITION__NAME), _function_3);
        final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
          it.setNewLines(1, 1, 2);
        };
        document.<ParameterSetDefinition>append(parameterSetDefinition, _function_4);
        final ISemanticRegion open = this.textRegionExtensions.regionFor(parameterSetDefinition).keyword("{");
        final ISemanticRegion close = this.textRegionExtensions.regionFor(parameterSetDefinition).keyword("}");
        final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
          it.newLine();
        };
        document.prepend(open, _function_5);
        final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it) -> {
          it.newLine();
        };
        document.append(open, _function_6);
        final Procedure1<IHiddenRegionFormatter> _function_7 = (IHiddenRegionFormatter it) -> {
          it.indent();
        };
        document.<ISemanticRegion, ISemanticRegion>interior(open, close, _function_7);
      }
    }
  }
  
  public void format(final Object parameterSetRepository, final IFormattableDocument document) {
    if (parameterSetRepository instanceof XtextResource) {
      _format((XtextResource)parameterSetRepository, document);
      return;
    } else if (parameterSetRepository instanceof AttributeDefinition) {
      _format((AttributeDefinition)parameterSetRepository, document);
      return;
    } else if (parameterSetRepository instanceof AttributeRefinement) {
      _format((AttributeRefinement)parameterSetRepository, document);
      return;
    } else if (parameterSetRepository instanceof InlineEnumerationType) {
      _format((InlineEnumerationType)parameterSetRepository, document);
      return;
    } else if (parameterSetRepository instanceof ParameterSetRepository) {
      _format((ParameterSetRepository)parameterSetRepository, document);
      return;
    } else if (parameterSetRepository instanceof ParamDefModel) {
      _format((ParamDefModel)parameterSetRepository, document);
      return;
    } else if (parameterSetRepository instanceof EObject) {
      _format((EObject)parameterSetRepository, document);
      return;
    } else if (parameterSetRepository == null) {
      _format((Void)null, document);
      return;
    } else if (parameterSetRepository != null) {
      _format(parameterSetRepository, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(parameterSetRepository, document).toString());
    }
  }
}
