/********************************************************************************
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 ********************************************************************************/
package org.eclipse.smartmdsd.xtext.service.serviceDefinition.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.smartmdsd.ecore.base.documentation.AbstractDocumentationElement;
import org.eclipse.smartmdsd.ecore.base.documentation.DocumentationPackage;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.CommunicationPatternPackage;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.EventPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.PushPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.QueryPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.SendPattern;
import org.eclipse.smartmdsd.ecore.service.coordinationPattern.CoordinationPatternPackage;
import org.eclipse.smartmdsd.ecore.service.coordinationPattern.DynamicWiringPattern;
import org.eclipse.smartmdsd.ecore.service.coordinationPattern.MonitoringPattern;
import org.eclipse.smartmdsd.ecore.service.coordinationPattern.ParameterPattern;
import org.eclipse.smartmdsd.ecore.service.coordinationPattern.StatePattern;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommRepoImport;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommunicationServiceUsage;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CoordinationServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ForkingServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.JoiningServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.RequestAnswerServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefModel;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefRepository;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefinitionPackage;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceProperty;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceRepoVersion;
import org.eclipse.smartmdsd.xtext.base.docuterminals.serializer.DocuTerminalsSemanticSequencer;
import org.eclipse.smartmdsd.xtext.service.serviceDefinition.services.ServiceDefinitionGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class ServiceDefinitionSemanticSequencer extends DocuTerminalsSemanticSequencer {

	@Inject
	private ServiceDefinitionGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == CommunicationPatternPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case CommunicationPatternPackage.EVENT_PATTERN:
				sequence_EventPattern(context, (EventPattern) semanticObject); 
				return; 
			case CommunicationPatternPackage.PUSH_PATTERN:
				sequence_PushPattern(context, (PushPattern) semanticObject); 
				return; 
			case CommunicationPatternPackage.QUERY_PATTERN:
				sequence_QueryPattern(context, (QueryPattern) semanticObject); 
				return; 
			case CommunicationPatternPackage.SEND_PATTERN:
				sequence_SendPattern(context, (SendPattern) semanticObject); 
				return; 
			}
		else if (epackage == CoordinationPatternPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case CoordinationPatternPackage.DYNAMIC_WIRING_PATTERN:
				sequence_DynamicWiringPattern(context, (DynamicWiringPattern) semanticObject); 
				return; 
			case CoordinationPatternPackage.MONITORING_PATTERN:
				sequence_MonitoringPattern(context, (MonitoringPattern) semanticObject); 
				return; 
			case CoordinationPatternPackage.PARAMETER_PATTERN:
				sequence_ParameterPattern(context, (ParameterPattern) semanticObject); 
				return; 
			case CoordinationPatternPackage.STATE_PATTERN:
				sequence_StatePattern(context, (StatePattern) semanticObject); 
				return; 
			}
		else if (epackage == DocumentationPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case DocumentationPackage.ABSTRACT_DOCUMENTATION_ELEMENT:
				sequence_AbstractDocumentationElement(context, (AbstractDocumentationElement) semanticObject); 
				return; 
			}
		else if (epackage == ServiceDefinitionPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case ServiceDefinitionPackage.COMM_REPO_IMPORT:
				sequence_CommRepoImport(context, (CommRepoImport) semanticObject); 
				return; 
			case ServiceDefinitionPackage.COMMUNICATION_SERVICE_USAGE:
				sequence_CommunicationServiceUsage(context, (CommunicationServiceUsage) semanticObject); 
				return; 
			case ServiceDefinitionPackage.COORDINATION_SERVICE_DEFINITION:
				sequence_CoordinationServiceDefinition(context, (CoordinationServiceDefinition) semanticObject); 
				return; 
			case ServiceDefinitionPackage.FORKING_SERVICE_DEFINITION:
				sequence_ForkingServiceDefinition(context, (ForkingServiceDefinition) semanticObject); 
				return; 
			case ServiceDefinitionPackage.JOINING_SERVICE_DEFINITION:
				sequence_JoyningServiceDefinition(context, (JoiningServiceDefinition) semanticObject); 
				return; 
			case ServiceDefinitionPackage.REQUEST_ANSWER_SERVICE_DEFINITION:
				sequence_RequestAnswerServiceDefinition(context, (RequestAnswerServiceDefinition) semanticObject); 
				return; 
			case ServiceDefinitionPackage.SERVICE_DEF_MODEL:
				sequence_ServiceDefModel(context, (ServiceDefModel) semanticObject); 
				return; 
			case ServiceDefinitionPackage.SERVICE_DEF_REPOSITORY:
				sequence_ServiceDefRepository(context, (ServiceDefRepository) semanticObject); 
				return; 
			case ServiceDefinitionPackage.SERVICE_PROPERTY:
				sequence_ServiceProperty(context, (ServiceProperty) semanticObject); 
				return; 
			case ServiceDefinitionPackage.SERVICE_REPO_VERSION:
				sequence_ServiceRepoVersion(context, (ServiceRepoVersion) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     CommRepoImport returns CommRepoImport
	 *
	 * Constraint:
	 *     importedNamespace=FQNW
	 */
	protected void sequence_CommRepoImport(ISerializationContext context, CommRepoImport semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, ServiceDefinitionPackage.Literals.COMM_REPO_IMPORT__IMPORTED_NAMESPACE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ServiceDefinitionPackage.Literals.COMM_REPO_IMPORT__IMPORTED_NAMESPACE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getCommRepoImportAccess().getImportedNamespaceFQNWParserRuleCall_1_0(), semanticObject.getImportedNamespace());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     CommunicationServiceUsage returns CommunicationServiceUsage
	 *
	 * Constraint:
	 *     (name=ID uses=[CommunicationServiceDefinition|FQN])
	 */
	protected void sequence_CommunicationServiceUsage(ISerializationContext context, CommunicationServiceUsage semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, ServiceDefinitionPackage.Literals.COMMUNICATION_SERVICE_USAGE__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ServiceDefinitionPackage.Literals.COMMUNICATION_SERVICE_USAGE__NAME));
			if (transientValues.isValueTransient(semanticObject, ServiceDefinitionPackage.Literals.COMMUNICATION_SERVICE_USAGE__USES) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ServiceDefinitionPackage.Literals.COMMUNICATION_SERVICE_USAGE__USES));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getCommunicationServiceUsageAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getCommunicationServiceUsageAccess().getUsesCommunicationServiceDefinitionFQNParserRuleCall_3_0_1(), semanticObject.eGet(ServiceDefinitionPackage.Literals.COMMUNICATION_SERVICE_USAGE__USES, false));
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     AbstractServiceDefinition returns CoordinationServiceDefinition
	 *     CoordinationServiceDefinition returns CoordinationServiceDefinition
	 *
	 * Constraint:
	 *     (
	 *         documentation=DOCU_COMMENT? 
	 *         name=ID 
	 *         (statePattern=StatePattern | parameterPattern=ParameterPattern | monitoringPattern=MonitoringPattern | wiringPattern=DynamicWiringPattern)* 
	 *         services+=CommunicationServiceUsage* 
	 *         properties+=ServiceProperty*
	 *     )
	 */
	protected void sequence_CoordinationServiceDefinition(ISerializationContext context, CoordinationServiceDefinition semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     DynamicWiringPattern returns DynamicWiringPattern
	 *
	 * Constraint:
	 *     {DynamicWiringPattern}
	 */
	protected void sequence_DynamicWiringPattern(ISerializationContext context, DynamicWiringPattern semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ForkingPatternInstance returns EventPattern
	 *     EventPattern returns EventPattern
	 *
	 * Constraint:
	 *     (eventType=[CommunicationObject|FQN] | activationType=[CommunicationObject|FQN] | eventStateType=[CommunicationObject|FQN])+
	 */
	protected void sequence_EventPattern(ISerializationContext context, EventPattern semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AbstractServiceDefinition returns ForkingServiceDefinition
	 *     CommunicationServiceDefinition returns ForkingServiceDefinition
	 *     ForkingServiceDefinition returns ForkingServiceDefinition
	 *
	 * Constraint:
	 *     (documentation=DOCU_COMMENT? name=ID pattern=ForkingPatternInstance properties+=ServiceProperty*)
	 */
	protected void sequence_ForkingServiceDefinition(ISerializationContext context, ForkingServiceDefinition semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AbstractServiceDefinition returns JoiningServiceDefinition
	 *     CommunicationServiceDefinition returns JoiningServiceDefinition
	 *     JoyningServiceDefinition returns JoiningServiceDefinition
	 *
	 * Constraint:
	 *     (documentation=DOCU_COMMENT? name=ID pattern=JoiningPatternInstance properties+=ServiceProperty*)
	 */
	protected void sequence_JoyningServiceDefinition(ISerializationContext context, JoiningServiceDefinition semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     MonitoringPattern returns MonitoringPattern
	 *
	 * Constraint:
	 *     {MonitoringPattern}
	 */
	protected void sequence_MonitoringPattern(ISerializationContext context, MonitoringPattern semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ParameterPattern returns ParameterPattern
	 *
	 * Constraint:
	 *     parameterSet=[ParameterSetDefinition|FQN]
	 */
	protected void sequence_ParameterPattern(ISerializationContext context, ParameterPattern semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, CoordinationPatternPackage.Literals.PARAMETER_PATTERN__PARAMETER_SET) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CoordinationPatternPackage.Literals.PARAMETER_PATTERN__PARAMETER_SET));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getParameterPatternAccess().getParameterSetParameterSetDefinitionFQNParserRuleCall_3_0_1(), semanticObject.eGet(CoordinationPatternPackage.Literals.PARAMETER_PATTERN__PARAMETER_SET, false));
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     ForkingPatternInstance returns PushPattern
	 *     PushPattern returns PushPattern
	 *
	 * Constraint:
	 *     dataType=[CommunicationObject|FQN]
	 */
	protected void sequence_PushPattern(ISerializationContext context, PushPattern semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, CommunicationPatternPackage.Literals.PUSH_PATTERN__DATA_TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CommunicationPatternPackage.Literals.PUSH_PATTERN__DATA_TYPE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getPushPatternAccess().getDataTypeCommunicationObjectFQNParserRuleCall_5_0_1(), semanticObject.eGet(CommunicationPatternPackage.Literals.PUSH_PATTERN__DATA_TYPE, false));
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     RequestAnswerPattern returns QueryPattern
	 *     QueryPattern returns QueryPattern
	 *
	 * Constraint:
	 *     (requestType=[CommunicationObject|FQN] | answerType=[CommunicationObject|FQN])+
	 */
	protected void sequence_QueryPattern(ISerializationContext context, QueryPattern semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AbstractServiceDefinition returns RequestAnswerServiceDefinition
	 *     CommunicationServiceDefinition returns RequestAnswerServiceDefinition
	 *     RequestAnswerServiceDefinition returns RequestAnswerServiceDefinition
	 *
	 * Constraint:
	 *     (documentation=DOCU_COMMENT? name=ID pattern=RequestAnswerPattern properties+=ServiceProperty*)
	 */
	protected void sequence_RequestAnswerServiceDefinition(ISerializationContext context, RequestAnswerServiceDefinition semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     JoiningPatternInstance returns SendPattern
	 *     SendPattern returns SendPattern
	 *
	 * Constraint:
	 *     dataType=[CommunicationObject|FQN]
	 */
	protected void sequence_SendPattern(ISerializationContext context, SendPattern semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, CommunicationPatternPackage.Literals.SEND_PATTERN__DATA_TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CommunicationPatternPackage.Literals.SEND_PATTERN__DATA_TYPE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getSendPatternAccess().getDataTypeCommunicationObjectFQNParserRuleCall_5_0_1(), semanticObject.eGet(CommunicationPatternPackage.Literals.SEND_PATTERN__DATA_TYPE, false));
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     ServiceDefModel returns ServiceDefModel
	 *
	 * Constraint:
	 *     (imports+=CommRepoImport* repository=ServiceDefRepository?)
	 */
	protected void sequence_ServiceDefModel(ISerializationContext context, ServiceDefModel semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ServiceDefRepository returns ServiceDefRepository
	 *
	 * Constraint:
	 *     (documentation=DOCU_COMMENT? name=ID version=ServiceRepoVersion? services+=AbstractServiceDefinition*)
	 */
	protected void sequence_ServiceDefRepository(ISerializationContext context, ServiceDefRepository semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ServiceProperty returns ServiceProperty
	 *
	 * Constraint:
	 *     name=ID
	 */
	protected void sequence_ServiceProperty(ISerializationContext context, ServiceProperty semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, ServiceDefinitionPackage.Literals.SERVICE_PROPERTY__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ServiceDefinitionPackage.Literals.SERVICE_PROPERTY__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getServicePropertyAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     ServiceRepoVersion returns ServiceRepoVersion
	 *
	 * Constraint:
	 *     (major=EInt minor=EInt patch=EInt?)
	 */
	protected void sequence_ServiceRepoVersion(ISerializationContext context, ServiceRepoVersion semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     StatePattern returns StatePattern
	 *
	 * Constraint:
	 *     (lifecycle=[StateMachine|FQN] modes=[ComponentModeCollection|FQN]?)
	 */
	protected void sequence_StatePattern(ISerializationContext context, StatePattern semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
}
