/**
 * Copyright (c) 2021 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.system.systemParameter;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentArchitecturePackage;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.SystemComponentArchitecture;
import org.eclipse.smartmdsd.ui.factories.ISmartMDSDModelFactory;

@SuppressWarnings("all")
public class SmartMDSDSystemParameterFactory implements ISmartMDSDModelFactory {
  @Override
  public EPackage getEPackage() {
    return SystemParameterPackage.eINSTANCE;
  }
  
  @Override
  public Collection<EPackage> getParentEPackages() {
    return Collections.<EPackage>singletonList(ComponentArchitecturePackage.eINSTANCE);
  }
  
  @Override
  public EObject createDefaultModel(final String projectName, final Collection<EObject> parentModels) {
    SystemComponentArchitecture compArch = null;
    for (final EObject parent : parentModels) {
      if ((parent instanceof SystemComponentArchitecture)) {
        compArch = ((SystemComponentArchitecture)parent);
      }
    }
    final SystemParamModel model = SystemParameterFactory.eINSTANCE.createSystemParamModel();
    model.setName(projectName);
    if ((compArch != null)) {
      model.setSystem(compArch);
    }
    return model;
  }
}
