/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.navigator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.smartmdsd.navigator.SmartMDSDProjectExplorer;
import org.eclipse.smartmdsd.ui.ISmartMDSDProjectCustomizer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;

public class SmartMDSDNewProjectFormatter
implements ISmartMDSDProjectCustomizer {
    public void customizeProject(final IProject project, IProgressMonitor monitor) throws CoreException {
        WorkspaceJob job = new WorkspaceJob("Expand newly created project " + project.getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                project.refreshLocal(2, monitor);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        IViewReference[] iViewReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
                        int n = iViewReferenceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IViewPart view;
                            IViewReference ref = iViewReferenceArray[n2];
                            if (ref.getId().contentEquals("org.eclipse.smartmdsd.navigator.view") && (view = ref.getView(false)) instanceof SmartMDSDProjectExplorer) {
                                SmartMDSDProjectExplorer explorer = (SmartMDSDProjectExplorer)view;
                                explorer.getCommonViewer().expandToLevel((Object)project, 2);
                                explorer.getCommonViewer().refresh((Object)project);
                            }
                            ++n2;
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)project);
        job.schedule();
    }
}

