/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.service.communicationObject.AbstractCommElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommElementReference;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class CommObjectCiGenerator {
  @Inject
  @Extension
  private CommObjectGenHelpers _commObjectGenHelpers;
  
  public CharSequence generateCiInfo(final CommObjectsRepository repo) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("\"id\" : \"");
    String _string = this._commObjectGenHelpers.getRepoNamespace(repo).toString();
    _builder.append(_string, "\t");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("\"type\" : \"DomainModel\",");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("\"dependprojects\" : [ ");
    {
      final Function1<String, String> _function = (String x) -> {
        return x;
      };
      List<String> _sortBy = IterableExtensions.<String, String>sortBy(this.getReferencedCommObjectsName(repo), _function);
      boolean _hasElements = false;
      for(final String reponame : _sortBy) {
        if (!_hasElements) {
          _hasElements = true;
          _builder.append("", "\t");
        } else {
          _builder.appendImmediate(",", "\t");
        }
        _builder.append("\"");
        _builder.append(reponame, "\t");
        _builder.append("\"");
      }
      if (_hasElements) {
        _builder.append("", "\t");
      }
    }
    _builder.append(" ]");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public Collection<String> getReferencedCommObjectsName(final CommObjectsRepository repo) {
    Collection<String> repoNames = new HashSet<String>();
    EList<AbstractCommElement> _elements = repo.getElements();
    for (final AbstractCommElement abstrel : _elements) {
      if ((abstrel instanceof CommunicationObject)) {
        EList<AttributeDefinition> _attributes = ((CommunicationObject)abstrel).getAttributes();
        for (final AttributeDefinition attr : _attributes) {
          {
            final AbstractAttributeType type = attr.getType();
            if ((type instanceof CommElementReference)) {
              final AbstractCommElement id = ((CommElementReference)type).getTypeName();
              if ((id instanceof CommunicationObject)) {
                String _string = this._commObjectGenHelpers.getRepoNamespace(id).toString();
                String _string_1 = this._commObjectGenHelpers.getRepoNamespace(repo).toString();
                boolean _notEquals = (!Objects.equal(_string, _string_1));
                if (_notEquals) {
                  repoNames.add(this._commObjectGenHelpers.getRepoNamespace(id).toString());
                }
              }
            }
          }
        }
      }
    }
    return repoNames;
  }
}
