/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PRIMITIVE_TYPE_NAME;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PrimitiveType;
import org.eclipse.smartmdsd.ecore.base.documentation.AbstractDocumentationElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.AbstractCommElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommElementReference;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.communicationObject.Enumeration;
import org.eclipse.smartmdsd.ecore.service.communicationObject.Version;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.basicAttributes.BasicAttributesGenHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class CommObjectGenHelpers extends BasicAttributesGenHelpers {
  @Override
  public String compileAttributeParentTypeName(final AttributeDefinition attr) {
    String _xblockexpression = null;
    {
      final EObject parent = attr.eContainer();
      String _xifexpression = null;
      if ((parent instanceof CommunicationObject)) {
        _xifexpression = ((CommunicationObject)parent).getName();
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected CharSequence _compileType(final CommElementReference ref) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _idlStructName = this.getIdlStructName(ref.getTypeName());
    _builder.append(_idlStructName);
    return _builder;
  }
  
  protected CharSequence _compileType(final PrimitiveType pt) {
    String _switchResult = null;
    boolean _matched = false;
    PRIMITIVE_TYPE_NAME _typeName = pt.getTypeName();
    boolean _equals = Objects.equal(_typeName, PRIMITIVE_TYPE_NAME.STRING);
    if (_equals) {
      _matched=true;
      _switchResult = "ACE_CString";
    }
    if (!_matched) {
      String _compileCdrType = this.compileCdrType(pt);
      _switchResult = ("ACE_CDR::" + _compileCdrType);
    }
    return _switchResult;
  }
  
  protected String _compileCdrType(final CommElementReference ref) {
    String _xifexpression = null;
    AbstractCommElement _typeName = ref.getTypeName();
    if ((_typeName instanceof Enumeration)) {
      _xifexpression = "Long";
    } else {
      _xifexpression = "";
    }
    return _xifexpression;
  }
  
  protected String _compileCdrType(final PrimitiveType pt) {
    String _switchResult = null;
    boolean _matched = false;
    PRIMITIVE_TYPE_NAME _typeName = pt.getTypeName();
    boolean _equals = Objects.equal(_typeName, PRIMITIVE_TYPE_NAME.INT8);
    if (_equals) {
      _matched=true;
      _switchResult = "Char";
    }
    if (!_matched) {
      PRIMITIVE_TYPE_NAME _typeName_1 = pt.getTypeName();
      boolean _equals_1 = Objects.equal(_typeName_1, PRIMITIVE_TYPE_NAME.INT16);
      if (_equals_1) {
        _matched=true;
        _switchResult = "Short";
      }
    }
    if (!_matched) {
      PRIMITIVE_TYPE_NAME _typeName_2 = pt.getTypeName();
      boolean _equals_2 = Objects.equal(_typeName_2, PRIMITIVE_TYPE_NAME.INT32);
      if (_equals_2) {
        _matched=true;
        _switchResult = "Long";
      }
    }
    if (!_matched) {
      PRIMITIVE_TYPE_NAME _typeName_3 = pt.getTypeName();
      boolean _equals_3 = Objects.equal(_typeName_3, PRIMITIVE_TYPE_NAME.INT64);
      if (_equals_3) {
        _matched=true;
        _switchResult = "LongLong";
      }
    }
    if (!_matched) {
      PRIMITIVE_TYPE_NAME _typeName_4 = pt.getTypeName();
      boolean _equals_4 = Objects.equal(_typeName_4, PRIMITIVE_TYPE_NAME.UINT8);
      if (_equals_4) {
        _matched=true;
        _switchResult = "Octet";
      }
    }
    if (!_matched) {
      PRIMITIVE_TYPE_NAME _typeName_5 = pt.getTypeName();
      boolean _equals_5 = Objects.equal(_typeName_5, PRIMITIVE_TYPE_NAME.UINT16);
      if (_equals_5) {
        _matched=true;
        _switchResult = "UShort";
      }
    }
    if (!_matched) {
      PRIMITIVE_TYPE_NAME _typeName_6 = pt.getTypeName();
      boolean _equals_6 = Objects.equal(_typeName_6, PRIMITIVE_TYPE_NAME.UINT32);
      if (_equals_6) {
        _matched=true;
        _switchResult = "ULong";
      }
    }
    if (!_matched) {
      PRIMITIVE_TYPE_NAME _typeName_7 = pt.getTypeName();
      boolean _equals_7 = Objects.equal(_typeName_7, PRIMITIVE_TYPE_NAME.UINT64);
      if (_equals_7) {
        _matched=true;
        _switchResult = "ULongLong";
      }
    }
    if (!_matched) {
      PRIMITIVE_TYPE_NAME _typeName_8 = pt.getTypeName();
      boolean _equals_8 = Objects.equal(_typeName_8, PRIMITIVE_TYPE_NAME.FLOAT);
      if (_equals_8) {
        _matched=true;
        _switchResult = "Float";
      }
    }
    if (!_matched) {
      PRIMITIVE_TYPE_NAME _typeName_9 = pt.getTypeName();
      boolean _equals_9 = Objects.equal(_typeName_9, PRIMITIVE_TYPE_NAME.DOUBLE);
      if (_equals_9) {
        _matched=true;
        _switchResult = "Double";
      }
    }
    if (!_matched) {
      PRIMITIVE_TYPE_NAME _typeName_10 = pt.getTypeName();
      boolean _equals_10 = Objects.equal(_typeName_10, PRIMITIVE_TYPE_NAME.STRING);
      if (_equals_10) {
        _matched=true;
        _switchResult = "Char";
      }
    }
    if (!_matched) {
      PRIMITIVE_TYPE_NAME _typeName_11 = pt.getTypeName();
      boolean _equals_11 = Objects.equal(_typeName_11, PRIMITIVE_TYPE_NAME.BOOLEAN);
      if (_equals_11) {
        _matched=true;
        _switchResult = "Boolean";
      }
    }
    if (!_matched) {
      _switchResult = "Octet";
    }
    return _switchResult;
  }
  
  public boolean getMany(final AttributeDefinition attr) {
    ArrayType _array = attr.getType().getArray();
    return (_array != null);
  }
  
  public boolean getDefval(final AttributeDefinition attr) {
    AbstractValue _defaultvalue = attr.getDefaultvalue();
    return (_defaultvalue != null);
  }
  
  public String getCardinality(final AttributeDefinition attr) {
    AbstractAttributeType type = attr.getType();
    ArrayType _array = type.getArray();
    boolean _tripleNotEquals = (_array != null);
    if (_tripleNotEquals) {
      String _length = type.getArray().getLength();
      boolean _tripleNotEquals_1 = (_length != null);
      if (_tripleNotEquals_1) {
        return type.getArray().getLength();
      }
    }
    return "";
  }
  
  public CharSequence getIdlHeaderFileName(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String _firstUpper = StringExtensions.toFirstUpper(co.getName());
    _builder.append(_firstUpper);
    _builder.append("Data.hh");
    return _builder;
  }
  
  public CharSequence getSerializationHeaderFileName(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String _firstUpper = StringExtensions.toFirstUpper(co.getName());
    _builder.append(_firstUpper);
    _builder.append("ACE.hh");
    return _builder;
  }
  
  public CharSequence getSerializationSourceFileName(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String _firstUpper = StringExtensions.toFirstUpper(co.getName());
    _builder.append(_firstUpper);
    _builder.append("ACE.cc");
    return _builder;
  }
  
  public CharSequence getBaseClassHeaderFileName(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String _firstUpper = StringExtensions.toFirstUpper(co.getName());
    _builder.append(_firstUpper);
    _builder.append("Core.hh");
    return _builder;
  }
  
  public CharSequence getBaseClassSourceFileName(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String _firstUpper = StringExtensions.toFirstUpper(co.getName());
    _builder.append(_firstUpper);
    _builder.append("Core.cc");
    return _builder;
  }
  
  public CharSequence getUserClassHeaderFileName(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String _firstUpper = StringExtensions.toFirstUpper(co.getName());
    _builder.append(_firstUpper);
    _builder.append(".hh");
    return _builder;
  }
  
  public CharSequence getUserClassHeaderFileNameFQN(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _repoNamespace = this.getRepoNamespace(co);
    _builder.append(_repoNamespace);
    _builder.append("/");
    String _firstUpper = StringExtensions.toFirstUpper(co.getName());
    _builder.append(_firstUpper);
    _builder.append(".hh");
    return _builder;
  }
  
  public CharSequence getSerailizationHeaderFileNameFQN(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _repoNamespace = this.getRepoNamespace(co);
    _builder.append(_repoNamespace);
    _builder.append("/");
    String _firstUpper = StringExtensions.toFirstUpper(co.getName());
    _builder.append(_firstUpper);
    _builder.append("ACE.hh");
    return _builder;
  }
  
  public CharSequence getUserClassSourceFileName(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String _firstUpper = StringExtensions.toFirstUpper(co.getName());
    _builder.append(_firstUpper);
    _builder.append(".cc");
    return _builder;
  }
  
  public CharSequence getEnumIdlFileName(final Enumeration en) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("enum");
    String _firstUpper = StringExtensions.toFirstUpper(en.getName());
    _builder.append(_firstUpper);
    _builder.append("Data.hh");
    return _builder;
  }
  
  public CharSequence getEnumClassFileName(final Enumeration en) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("enum");
    String _firstUpper = StringExtensions.toFirstUpper(en.getName());
    _builder.append(_firstUpper);
    _builder.append(".hh");
    return _builder;
  }
  
  protected CharSequence _getIdlStructName(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String _firstUpper = StringExtensions.toFirstUpper(co.getName());
    _builder.append(_firstUpper);
    return _builder;
  }
  
  protected CharSequence _getIdlStructName(final Enumeration co) {
    StringConcatenation _builder = new StringConcatenation();
    String _firstUpper = StringExtensions.toFirstUpper(co.getName());
    _builder.append(_firstUpper);
    return _builder;
  }
  
  public CharSequence getIdlInstanceName(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("idl_");
    String _name = co.getName();
    _builder.append(_name);
    return _builder;
  }
  
  public CharSequence getReferencedClassName(final AbstractAttributeType at) {
    if ((at instanceof CommElementReference)) {
      return this.getIdlStructName(((CommElementReference)at).getTypeName());
    }
    return "";
  }
  
  public CharSequence getBaseClassName(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String _firstUpper = StringExtensions.toFirstUpper(co.getName());
    _builder.append(_firstUpper);
    _builder.append("Core");
    return _builder;
  }
  
  public CharSequence getUserClassName(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String _firstUpper = StringExtensions.toFirstUpper(co.getName());
    _builder.append(_firstUpper);
    return _builder;
  }
  
  public CharSequence getIdlHeaderDefine(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    EObject _eContainer = co.eContainer();
    String _upperCase = ((CommObjectsRepository) _eContainer).getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_");
    String _upperCase_1 = co.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_DATA_H_");
    return _builder;
  }
  
  public CharSequence getSerializationHeaderDefine(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    EObject _eContainer = co.eContainer();
    String _upperCase = ((CommObjectsRepository) _eContainer).getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_");
    String _upperCase_1 = co.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_ACE_H_");
    return _builder;
  }
  
  public CharSequence getBaseClassHeaderDefine(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    EObject _eContainer = co.eContainer();
    String _upperCase = ((CommObjectsRepository) _eContainer).getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_");
    String _upperCase_1 = co.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_CORE_H_");
    return _builder;
  }
  
  public CharSequence getUserClassHeaderDefine(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    EObject _eContainer = co.eContainer();
    String _upperCase = ((CommObjectsRepository) _eContainer).getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_");
    String _upperCase_1 = co.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_H_");
    return _builder;
  }
  
  public CharSequence getEnumIdlDefine(final Enumeration en) {
    StringConcatenation _builder = new StringConcatenation();
    EObject _eContainer = en.eContainer();
    String _upperCase = ((CommObjectsRepository) _eContainer).getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_");
    String _upperCase_1 = en.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_ENUM_DATA_H_");
    return _builder;
  }
  
  public CharSequence getEnumDefine(final Enumeration en) {
    StringConcatenation _builder = new StringConcatenation();
    EObject _eContainer = en.eContainer();
    String _upperCase = ((CommObjectsRepository) _eContainer).getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_");
    String _upperCase_1 = en.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_ENUM_H_");
    return _builder;
  }
  
  protected Version _getRepoVersion(final CommObjectsRepository repo) {
    return repo.getVersion();
  }
  
  protected Version _getRepoVersion(final CommunicationObject co) {
    EObject _eContainer = co.eContainer();
    return ((CommObjectsRepository) _eContainer).getVersion();
  }
  
  protected Version _getRepoVersion(final Enumeration co) {
    EObject _eContainer = co.eContainer();
    return ((CommObjectsRepository) _eContainer).getVersion();
  }
  
  protected CharSequence _getRepoNamespace(final CommObjectsRepository repo) {
    StringConcatenation _builder = new StringConcatenation();
    String _firstUpper = StringExtensions.toFirstUpper(repo.getName());
    _builder.append(_firstUpper);
    return _builder;
  }
  
  protected CharSequence _getRepoNamespace(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    EObject _eContainer = co.eContainer();
    String _firstUpper = StringExtensions.toFirstUpper(((CommObjectsRepository) _eContainer).getName());
    _builder.append(_firstUpper);
    return _builder;
  }
  
  protected CharSequence _getRepoNamespace(final Enumeration co) {
    StringConcatenation _builder = new StringConcatenation();
    EObject _eContainer = co.eContainer();
    String _firstUpper = StringExtensions.toFirstUpper(((CommObjectsRepository) _eContainer).getName());
    _builder.append(_firstUpper);
    return _builder;
  }
  
  protected CharSequence _getRepoNamespace(final CommElementReference co) {
    StringConcatenation _builder = new StringConcatenation();
    EObject _eContainer = co.getTypeName().eContainer();
    String _firstUpper = StringExtensions.toFirstUpper(((CommObjectsRepository) _eContainer).getName());
    _builder.append(_firstUpper);
    return _builder;
  }
  
  protected CharSequence _getRepoNamespace(final PrimitiveType pr) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence getReferencedRepoNamespace(final AbstractAttributeType at) {
    if ((at instanceof CommElementReference)) {
      return this.getRepoNamespace(((CommElementReference)at).getTypeName());
    }
    return "";
  }
  
  public CharSequence getFullyQualifiedNameCpp(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _repoNamespace = this.getRepoNamespace(co);
    _builder.append(_repoNamespace);
    _builder.append("::");
    CharSequence _userClassName = this.getUserClassName(co);
    _builder.append(_userClassName);
    return _builder;
  }
  
  public Set<String> generateIdlInclude(final EList<AttributeDefinition> elems) {
    Set<String> includes = new HashSet<String>();
    for (final AttributeDefinition el : elems) {
      {
        AbstractAttributeType type = el.getType();
        if ((type instanceof CommElementReference)) {
          final AbstractCommElement id = ((CommElementReference)type).getTypeName();
          boolean _matched = false;
          if (id instanceof CommunicationObject) {
            _matched=true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("#include \"");
            CharSequence _repoNamespace = this.getRepoNamespace(id);
            _builder.append(_repoNamespace);
            _builder.append("/");
            CharSequence _idlHeaderFileName = this.getIdlHeaderFileName(((CommunicationObject)id));
            _builder.append(_idlHeaderFileName);
            _builder.append("\"");
            includes.add(_builder.toString());
          }
          if (!_matched) {
            if (id instanceof Enumeration) {
              _matched=true;
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("#include \"");
              CharSequence _repoNamespace = this.getRepoNamespace(id);
              _builder.append(_repoNamespace);
              _builder.append("/");
              CharSequence _enumIdlFileName = this.getEnumIdlFileName(((Enumeration)id));
              _builder.append(_enumIdlFileName);
              _builder.append("\"");
              includes.add(_builder.toString());
            }
          }
        }
      }
    }
    return includes;
  }
  
  public Set<String> generateSerializationInclude(final EList<AttributeDefinition> elems) {
    Set<String> includes = new HashSet<String>();
    for (final AttributeDefinition el : elems) {
      {
        AbstractAttributeType type = el.getType();
        if ((type instanceof CommElementReference)) {
          final AbstractCommElement id = ((CommElementReference)type).getTypeName();
          boolean _matched = false;
          if (id instanceof CommunicationObject) {
            _matched=true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("#include \"");
            CharSequence _repoNamespace = this.getRepoNamespace(id);
            _builder.append(_repoNamespace);
            _builder.append("/");
            CharSequence _serializationHeaderFileName = this.getSerializationHeaderFileName(((CommunicationObject)id));
            _builder.append(_serializationHeaderFileName);
            _builder.append("\"");
            includes.add(_builder.toString());
          }
          if (!_matched) {
            if (id instanceof Enumeration) {
              _matched=true;
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("#include \"");
              CharSequence _repoNamespace = this.getRepoNamespace(id);
              _builder.append(_repoNamespace);
              _builder.append("/");
              CharSequence _enumIdlFileName = this.getEnumIdlFileName(((Enumeration)id));
              _builder.append(_enumIdlFileName);
              _builder.append("\"");
              includes.add(_builder.toString());
            }
          }
        }
      }
    }
    return includes;
  }
  
  public Set<String> generateClassInclude(final EList<AttributeDefinition> elems) {
    Set<String> includes = new HashSet<String>();
    for (final AttributeDefinition el : elems) {
      {
        AbstractAttributeType type = el.getType();
        if ((type instanceof CommElementReference)) {
          final AbstractCommElement id = ((CommElementReference)type).getTypeName();
          boolean _matched = false;
          if (id instanceof CommunicationObject) {
            _matched=true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("#include \"");
            CharSequence _repoNamespace = this.getRepoNamespace(id);
            _builder.append(_repoNamespace);
            _builder.append("/");
            CharSequence _userClassHeaderFileName = this.getUserClassHeaderFileName(((CommunicationObject)id));
            _builder.append(_userClassHeaderFileName);
            _builder.append("\"");
            includes.add(_builder.toString());
          }
          if (!_matched) {
            if (id instanceof Enumeration) {
              _matched=true;
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("#include \"");
              CharSequence _repoNamespace = this.getRepoNamespace(id);
              _builder.append(_repoNamespace);
              _builder.append("/");
              CharSequence _enumClassFileName = this.getEnumClassFileName(((Enumeration)id));
              _builder.append(_enumClassFileName);
              _builder.append("\"");
              includes.add(_builder.toString());
            }
          }
        }
      }
    }
    return includes;
  }
  
  public Collection<DomainModelsGeneratorExtension> getDomainModelsGeneratorExtensions() {
    try {
      final ArrayList<DomainModelsGeneratorExtension> result = new ArrayList<DomainModelsGeneratorExtension>();
      final IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.smartmdsd.xtend.smartsoft.generator.DomainModelsGeneratorExtension");
      for (final IConfigurationElement ext : config) {
        {
          final Object obj = ext.createExecutableExtension("class");
          if ((obj instanceof DomainModelsGeneratorExtension)) {
            result.add(((DomainModelsGeneratorExtension)obj));
          }
        }
      }
      return result;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public CharSequence compileType(final AbstractAttributeType pt) {
    if (pt instanceof PrimitiveType) {
      return _compileType((PrimitiveType)pt);
    } else if (pt instanceof CommElementReference) {
      return _compileType((CommElementReference)pt);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(pt).toString());
    }
  }
  
  public String compileCdrType(final AbstractAttributeType pt) {
    if (pt instanceof PrimitiveType) {
      return _compileCdrType((PrimitiveType)pt);
    } else if (pt instanceof CommElementReference) {
      return _compileCdrType((CommElementReference)pt);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(pt).toString());
    }
  }
  
  public CharSequence getIdlStructName(final AbstractCommElement co) {
    if (co instanceof CommunicationObject) {
      return _getIdlStructName((CommunicationObject)co);
    } else if (co instanceof Enumeration) {
      return _getIdlStructName((Enumeration)co);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(co).toString());
    }
  }
  
  public Version getRepoVersion(final AbstractDocumentationElement co) {
    if (co instanceof CommunicationObject) {
      return _getRepoVersion((CommunicationObject)co);
    } else if (co instanceof Enumeration) {
      return _getRepoVersion((Enumeration)co);
    } else if (co instanceof CommObjectsRepository) {
      return _getRepoVersion((CommObjectsRepository)co);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(co).toString());
    }
  }
  
  public CharSequence getRepoNamespace(final EObject co) {
    if (co instanceof CommunicationObject) {
      return _getRepoNamespace((CommunicationObject)co);
    } else if (co instanceof Enumeration) {
      return _getRepoNamespace((Enumeration)co);
    } else if (co instanceof PrimitiveType) {
      return _getRepoNamespace((PrimitiveType)co);
    } else if (co instanceof CommElementReference) {
      return _getRepoNamespace((CommElementReference)co);
    } else if (co instanceof CommObjectsRepository) {
      return _getRepoNamespace((CommObjectsRepository)co);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(co).toString());
    }
  }
}
