/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.AbstractCommElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommElementReference;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObjectUtility;
import org.eclipse.smartmdsd.ecore.service.communicationObject.Enumeration;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class DocumentationGenerator {
  @Inject
  @Extension
  private CommObjectGenHelpers _commObjectGenHelpers;
  
  @Inject
  @Extension
  private CommunicationObjectUtility _communicationObjectUtility;
  
  @Inject
  private IEObjectDocumentationProvider doc;
  
  public CharSequence generateDocumentation(final CommObjectsRepository repo) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/** ");
    _builder.newLine();
    {
      Iterable<CommunicationObject> _filter = Iterables.<CommunicationObject>filter(repo.getElements(), CommunicationObject.class);
      for(final CommunicationObject co : _filter) {
        _builder.append("\\class ");
        String _name = repo.getName();
        _builder.append(_name);
        _builder.append("::");
        String _name_1 = co.getName();
        _builder.append(_name_1);
        _builder.append("Core");
        _builder.newLineIfNotEmpty();
        String _documentation = this.doc.getDocumentation(co);
        _builder.append(_documentation);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("Structure of Communication Object:");
        _builder.newLine();
        {
          EList<AttributeDefinition> _attributes = co.getAttributes();
          for(final AttributeDefinition el : _attributes) {
            {
              ArrayType _array = el.getType().getArray();
              boolean _tripleNotEquals = (_array != null);
              if (_tripleNotEquals) {
                _builder.append("- ");
                String _name_2 = el.getName();
                _builder.append(_name_2);
                _builder.append(": ");
                String _typeDef = this.typeDef(el.getType());
                _builder.append(_typeDef);
                _builder.append("[");
                String _cardinality = this._commObjectGenHelpers.getCardinality(el);
                _builder.append(_cardinality);
                _builder.append("] ");
                {
                  AbstractValue _defaultvalue = el.getDefaultvalue();
                  boolean _tripleNotEquals_1 = (_defaultvalue != null);
                  if (_tripleNotEquals_1) {
                    _builder.append(" = ");
                    String _valueString = this._communicationObjectUtility.getValueString(el.getDefaultvalue());
                    _builder.append(_valueString);
                    _builder.append(" ");
                  }
                }
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("- ");
                String _name_3 = el.getName();
                _builder.append(_name_3);
                _builder.append(": ");
                String _typeDef_1 = this.typeDef(el.getType());
                _builder.append(_typeDef_1);
                _builder.append(" ");
                {
                  AbstractValue _defaultvalue_1 = el.getDefaultvalue();
                  String _valueString_1 = null;
                  if (_defaultvalue_1!=null) {
                    _valueString_1=this._communicationObjectUtility.getValueString(_defaultvalue_1);
                  }
                  boolean _tripleNotEquals_2 = (_valueString_1 != null);
                  if (_tripleNotEquals_2) {
                    _builder.append(" = ");
                    String _valueString_2 = this._communicationObjectUtility.getValueString(el.getDefaultvalue());
                    _builder.append(_valueString_2);
                    _builder.append(" ");
                  }
                }
                _builder.newLineIfNotEmpty();
              }
            }
            {
              String _documentation_1 = this.doc.getDocumentation(el);
              boolean _tripleNotEquals_3 = (_documentation_1 != null);
              if (_tripleNotEquals_3) {
                _builder.append("<i> ");
                String _documentation_2 = this.doc.getDocumentation(el);
                _builder.append(_documentation_2);
                _builder.append(" </i>");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.newLine();
      }
    }
    {
      Iterable<Enumeration> _filter_1 = Iterables.<Enumeration>filter(repo.getElements(), Enumeration.class);
      for(final Enumeration en : _filter_1) {
        _builder.append("\\class ");
        String _name_4 = repo.getName();
        _builder.append(_name_4);
        _builder.append("::");
        String _name_5 = en.getName();
        _builder.append(_name_5);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("Structure of Enumeration:");
        _builder.newLine();
        {
          EList<EnumerationElement> _enums = en.getEnums();
          for(final EnumerationElement el_1 : _enums) {
            _builder.append("- ");
            String _name_6 = el_1.getName();
            _builder.append(_name_6);
            _builder.append(" ");
            _builder.newLineIfNotEmpty();
            {
              String _documentation_3 = this.doc.getDocumentation(el_1);
              boolean _tripleNotEquals_4 = (_documentation_3 != null);
              if (_tripleNotEquals_4) {
                _builder.append("<i> ");
                String _documentation_4 = this.doc.getDocumentation(el_1);
                _builder.append(_documentation_4);
                _builder.append(" </i>");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("@defgroup ");
    String _name_7 = repo.getName();
    _builder.append(_name_7);
    _builder.newLineIfNotEmpty();
    _builder.append("@ingroup commObjGroup");
    _builder.newLine();
    _builder.append("@{");
    _builder.newLine();
    _builder.append("\\page ");
    String _name_8 = repo.getName();
    _builder.append(_name_8);
    _builder.append("Page ");
    String _name_9 = repo.getName();
    _builder.append(_name_9);
    _builder.newLineIfNotEmpty();
    _builder.append("Class Reference: ");
    String _name_10 = repo.getName();
    _builder.append(_name_10);
    _builder.newLineIfNotEmpty();
    _builder.append("<hr>");
    _builder.newLine();
    _builder.newLine();
    {
      Iterable<CommunicationObject> _filter_2 = Iterables.<CommunicationObject>filter(repo.getElements(), CommunicationObject.class);
      for(final CommunicationObject co_1 : _filter_2) {
        _builder.append("@section ");
        String _name_11 = co_1.getName();
        _builder.append(_name_11);
        _builder.append(" ");
        String _name_12 = co_1.getName();
        _builder.append(_name_12);
        _builder.newLineIfNotEmpty();
        {
          EList<AttributeDefinition> _attributes_1 = co_1.getAttributes();
          for(final AttributeDefinition el_2 : _attributes_1) {
            {
              ArrayType _array_1 = el_2.getType().getArray();
              boolean _tripleNotEquals_5 = (_array_1 != null);
              if (_tripleNotEquals_5) {
                _builder.append("- ");
                String _name_13 = el_2.getName();
                _builder.append(_name_13);
                _builder.append(": ");
                String _typeDef2 = this.typeDef2(el_2.getType());
                _builder.append(_typeDef2);
                _builder.append("[");
                String _cardinality_1 = this._commObjectGenHelpers.getCardinality(el_2);
                _builder.append(_cardinality_1);
                _builder.append("] ");
                String _typeCast = this.getTypeCast(el_2.getType());
                _builder.append(_typeCast);
                _builder.append(" ");
                {
                  AbstractValue _defaultvalue_2 = el_2.getDefaultvalue();
                  boolean _tripleNotEquals_6 = (_defaultvalue_2 != null);
                  if (_tripleNotEquals_6) {
                    _builder.append(" = ");
                    String _valueString_3 = this._communicationObjectUtility.getValueString(el_2.getDefaultvalue());
                    _builder.append(_valueString_3);
                    _builder.append(" ");
                  }
                }
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("- ");
                String _name_14 = el_2.getName();
                _builder.append(_name_14);
                _builder.append(": ");
                String _typeDef2_1 = this.typeDef2(el_2.getType());
                _builder.append(_typeDef2_1);
                _builder.append(" ");
                String _typeCast_1 = this.getTypeCast(el_2.getType());
                _builder.append(_typeCast_1);
                _builder.append(" ");
                {
                  AbstractValue _defaultvalue_3 = el_2.getDefaultvalue();
                  boolean _tripleNotEquals_7 = (_defaultvalue_3 != null);
                  if (_tripleNotEquals_7) {
                    _builder.append(" = ");
                    String _valueString_4 = this._communicationObjectUtility.getValueString(el_2.getDefaultvalue());
                    _builder.append(_valueString_4);
                    _builder.append(" ");
                  }
                }
                _builder.newLineIfNotEmpty();
              }
            }
            {
              String _documentation_5 = this.doc.getDocumentation(el_2);
              boolean _tripleNotEquals_8 = (_documentation_5 != null);
              if (_tripleNotEquals_8) {
                _builder.append("<i> ");
                String _documentation_6 = this.doc.getDocumentation(el_2);
                _builder.append(_documentation_6);
                _builder.append(" </i>");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.newLine();
        _builder.append("Class Reference: ");
        String _name_15 = repo.getName();
        _builder.append(_name_15);
        _builder.append("::");
        String _name_16 = co_1.getName();
        _builder.append(_name_16);
        _builder.append("Core");
        _builder.newLineIfNotEmpty();
        _builder.append("<hr>");
        _builder.newLine();
      }
    }
    {
      Iterable<Enumeration> _filter_3 = Iterables.<Enumeration>filter(repo.getElements(), Enumeration.class);
      for(final Enumeration en_1 : _filter_3) {
        _builder.append("@section ");
        String _name_17 = en_1.getName();
        _builder.append(_name_17);
        _builder.append(" ");
        String _name_18 = en_1.getName();
        _builder.append(_name_18);
        _builder.newLineIfNotEmpty();
        {
          EList<EnumerationElement> _enums_1 = en_1.getEnums();
          for(final EnumerationElement el_3 : _enums_1) {
            _builder.append("- ");
            String _name_19 = el_3.getName();
            _builder.append(_name_19);
            _builder.append(" ");
            _builder.newLineIfNotEmpty();
            {
              String _documentation_7 = this.doc.getDocumentation(el_3);
              boolean _tripleNotEquals_9 = (_documentation_7 != null);
              if (_tripleNotEquals_9) {
                _builder.append("<i> ");
                String _documentation_8 = this.doc.getDocumentation(el_3);
                _builder.append(_documentation_8);
                _builder.append(" </i>");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.newLine();
        _builder.append("Class Reference: ");
        String _name_20 = repo.getName();
        _builder.append(_name_20);
        _builder.append("::");
        String _name_21 = en_1.getName();
        _builder.append(_name_21);
        _builder.newLineIfNotEmpty();
        _builder.append("<hr>");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.newLine();
    _builder.append("@}");
    _builder.newLine();
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }
  
  private String typeDef(final AbstractAttributeType type) {
    String _xifexpression = null;
    if ((type instanceof CommElementReference)) {
      CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(((CommElementReference)type).getTypeName());
      String _plus = (_repoNamespace + "::");
      String _name = ((CommElementReference)type).getTypeName().getName();
      _xifexpression = (_plus + _name);
    } else {
      _xifexpression = this._communicationObjectUtility.getTypeName(type);
    }
    return _xifexpression;
  }
  
  private String typeDef2(final AbstractAttributeType type) {
    String _xifexpression = null;
    if ((type instanceof CommElementReference)) {
      String _name = ((CommElementReference)type).getTypeName().getName();
      _xifexpression = ("@ref " + _name);
    } else {
      _xifexpression = this._communicationObjectUtility.getTypeName(type);
    }
    return _xifexpression;
  }
  
  private String getTypeCast(final AbstractAttributeType type) {
    if ((type instanceof CommElementReference)) {
      final AbstractCommElement id = ((CommElementReference)type).getTypeName();
      boolean _matched = false;
      if (id instanceof CommunicationObject) {
        _matched=true;
        return "(CommObj)";
      }
      if (!_matched) {
        if (id instanceof Enumeration) {
          _matched=true;
          return "(Enum)";
        }
      }
      return "";
    }
    return null;
  }
}
