/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component;

import com.google.inject.Inject;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class SmartComponentExtension {
  @Inject
  @Extension
  private SmartComponent _smartComponent;
  
  @Inject
  @Extension
  private CopyrightHelpers _copyrightHelpers;
  
  @Inject
  @Extension
  private ComponentGenHelpers _componentGenHelpers;
  
  public String getComponentExtensionHeaderFilename(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("Extension.hh");
    return _builder.toString();
  }
  
  public String getComponentExtensionSourceFilename(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("Extension.cc");
    return _builder.toString();
  }
  
  public CharSequence compileComponentExtensionHeader(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#ifndef ");
    String _upperCase = component.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_EXTENSION_HH_");
    _builder.newLineIfNotEmpty();
    _builder.append("#define ");
    String _upperCase_1 = component.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_EXTENSION_HH_");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include <string>");
    _builder.newLine();
    _builder.append("#include <atomic>");
    _builder.newLine();
    _builder.append("#include <future>");
    _builder.newLine();
    _builder.append("#include <chrono>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// include component\'s main class");
    _builder.newLine();
    _builder.append("#include \"");
    String _compHeaderFilename = this._smartComponent.getCompHeaderFilename(component);
    _builder.append(_compHeaderFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// forward declaration");
    _builder.newLine();
    _builder.append("class ");
    String _nameClass = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("class ");
    String _nameClass_1 = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass_1);
    _builder.append("Extension {");
    _builder.newLineIfNotEmpty();
    _builder.append("private:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::string extension_name;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::future<int> extension_future;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("protected:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// use this variable within extensionExecution() to check if the thread is commanded to shutdown");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::atomic<bool> cancelled;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// use this method to start internal extension thread");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual int startExtensionThread();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// implement this method in derived classes");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual int extensionExecution() = 0;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// use this method to start internal extension thread");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual int stopExtensionThread(const std::chrono::steady_clock::duration &timeoutTime=std::chrono::seconds(2));");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    String _nameClass_2 = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass_2, "\t");
    _builder.append("Extension(const std::string &name);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("virtual ~");
    String _nameClass_3 = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass_3, "\t");
    _builder.append("Extension();");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("inline std::string getName() const {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return extension_name;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void loadParameters(const SmartACE::SmartIniParameter &parameter);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void initialize(");
    String _nameClass_4 = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass_4, "\t");
    _builder.append(" *component, int argc, char* argv[]) = 0;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("virtual int onStartup();");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual int onShutdown(const std::chrono::steady_clock::duration &timeoutTime=std::chrono::seconds(2));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void destroy() = 0;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif /* ");
    String _upperCase_2 = component.getName().toUpperCase();
    _builder.append(_upperCase_2);
    _builder.append("_EXTENSION_HH_ */");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence compileComponentExtensionSource(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    String _componentExtensionHeaderFilename = this.getComponentExtensionHeaderFilename(component);
    _builder.append(_componentExtensionHeaderFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    String _nameClass = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass);
    _builder.append("Extension::");
    String _nameClass_1 = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass_1);
    _builder.append("Extension(const std::string &name)");
    _builder.newLineIfNotEmpty();
    _builder.append(":\textension_name(name)");
    _builder.newLine();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("cancelled = false;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("COMP->addExtension(this);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    String _nameClass_2 = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass_2);
    _builder.append("Extension::~");
    String _nameClass_3 = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass_3);
    _builder.append("Extension()");
    _builder.newLineIfNotEmpty();
    _builder.append("{  }");
    _builder.newLine();
    _builder.newLine();
    _builder.append("int ");
    String _nameClass_4 = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass_4);
    _builder.append("Extension::startExtensionThread()");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("cancelled = false;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// execute the task_execution() method in a new thread now");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("extension_future = std::async(std::launch::async, &");
    String _nameClass_5 = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass_5, "\t");
    _builder.append("Extension::extensionExecution, this);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return 0;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("int ");
    String _nameClass_6 = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass_6);
    _builder.append("Extension::stopExtensionThread(const std::chrono::steady_clock::duration &timeoutTime)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("cancelled = true;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// wait on extension thread to exit");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (extension_future.wait_for(timeoutTime) == std::future_status::timeout) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return -1;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return 0;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ");
    String _nameClass_7 = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass_7);
    _builder.append("Extension::loadParameters(const SmartACE::SmartIniParameter &parameter)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// no-op");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("int ");
    String _nameClass_8 = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass_8);
    _builder.append("Extension::onStartup()");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// default implementation just starts the internal thread");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return startExtensionThread();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("int ");
    String _nameClass_9 = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass_9);
    _builder.append("Extension::onShutdown(const std::chrono::steady_clock::duration &timeoutTime)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// default implementation stops the internal thread waiting up to timeoutTime until it is stopped (or a timeout occurs)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return stopExtensionThread(timeoutTime);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
