/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.base.documentation;

@SuppressWarnings("all")
public class DocumentationUtility {
  public static String getMultilineHtmlText(final String comment) {
    if (((comment != null) && (comment.trim().length() > 3))) {
      String trimmed_comment = comment.trim();
      boolean _startsWith = trimmed_comment.startsWith("///");
      if (_startsWith) {
        return DocumentationUtility.getFirstLine(comment);
      }
      boolean _startsWith_1 = trimmed_comment.startsWith("/**");
      if (_startsWith_1) {
        int _length = trimmed_comment.length();
        int _minus = (_length - 2);
        trimmed_comment = trimmed_comment.substring(3, _minus);
        String result = "<p>";
        final String[] lines = trimmed_comment.split(System.getProperty("line.separator"));
        for (final String line : lines) {
          {
            final String trimmed_line = line.trim();
            boolean _startsWith_2 = trimmed_line.startsWith("*");
            if (_startsWith_2) {
              String _substring = trimmed_line.substring(1);
              String _plus = (result + _substring);
              result = _plus;
            } else {
              result = (result + trimmed_line);
            }
            if ((trimmed_line.isEmpty() || trimmed_line.equals("*"))) {
              result = (result + "</p>\n<p>");
            } else {
              result = (result + "\n");
            }
          }
        }
        result = (result + "</p>");
        return result;
      }
    }
    return "";
  }
  
  public static String getFirstLine(final String comment) {
    if (((comment != null) && (comment.trim().length() > 3))) {
      String docu_text = comment.trim().substring(3);
      final String[] lines = docu_text.split(System.getProperty("line.separator"));
      String first_line = lines[0];
      boolean _endsWith = first_line.endsWith("*/");
      if (_endsWith) {
        int _length = first_line.length();
        int _minus = (_length - 2);
        first_line = first_line.substring(0, _minus);
      }
      return first_line;
    }
    return "";
  }
}
