/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.base.basicAttributes.scoping;

import com.google.common.base.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesPackage;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.InlineEnumerationType;
import org.eclipse.smartmdsd.xtext.base.basicAttributes.scoping.AbstractBasicAttributesScopeProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;

/**
 * This class contains custom scoping description.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#scoping
 * on how and when to use it.
 */
@SuppressWarnings("all")
public class BasicAttributesScopeProvider extends AbstractBasicAttributesScopeProvider {
  @Override
  public IScope getScope(final EObject context, final EReference reference) {
    EReference _enumerationValue_Value = BasicAttributesPackage.eINSTANCE.getEnumerationValue_Value();
    boolean _equals = Objects.equal(reference, _enumerationValue_Value);
    if (_equals) {
      return this.scopeForEnumRef(context);
    } else {
      return super.getScope(context, reference);
    }
  }
  
  public IScope scopeForEnumRef(final EObject context) {
    EObject parent = context.eContainer();
    if ((parent instanceof ArrayValue)) {
      parent = ((ArrayValue)parent).eContainer();
    }
    if ((parent instanceof AttributeDefinition)) {
      final AbstractAttributeType type = ((AttributeDefinition)parent).getType();
      if ((type instanceof InlineEnumerationType)) {
        return Scopes.scopeFor(((InlineEnumerationType)type).getEnums());
      }
    } else {
      if ((parent instanceof AttributeRefinement)) {
        final AbstractAttributeType type_1 = ((AttributeRefinement)parent).getAttribute().getType();
        if ((type_1 instanceof InlineEnumerationType)) {
          return Scopes.scopeFor(((InlineEnumerationType)type_1).getEnums());
        }
      }
    }
    return IScope.NULLSCOPE;
  }
}
