/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.parameterDefinition;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterSetDefinition;
import org.eclipse.smartmdsd.xtext.service.parameterDefinition.scoping.ParameterDefinitionIndex;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class ParameterDefinitionDefaultLib {
  @Inject
  @Extension
  private ParameterDefinitionIndex _parameterDefinitionIndex;
  
  public static final String DEFAULT_PARAM_PACKAGE = "defaultParameterLib";
  
  public static final String PARAMETER_LIB = (ParameterDefinitionDefaultLib.DEFAULT_PARAM_PACKAGE + "/defaultParameterLib.parameters");
  
  public static final String DEFAULT_PARAMETR_SET_SIMPLE = "EmptyDefaultParameterSet";
  
  public static final String DEFAULT_PARAMETR_SET = ((ParameterDefinitionDefaultLib.DEFAULT_PARAM_PACKAGE + ".") + ParameterDefinitionDefaultLib.DEFAULT_PARAMETR_SET_SIMPLE);
  
  public static final QualifiedName DEFAULT_PARAMETR_SET_QNAME = QualifiedName.create(ParameterDefinitionDefaultLib.DEFAULT_PARAM_PACKAGE).append(ParameterDefinitionDefaultLib.DEFAULT_PARAMETR_SET_SIMPLE);
  
  public URI getPluginURI() {
    String _name = this.getClass().getPackage().getName();
    String _plus = (_name + "/");
    String _plus_1 = (_plus + ParameterDefinitionDefaultLib.PARAMETER_LIB);
    return URI.createPlatformPluginURI(_plus_1, false);
  }
  
  public void loadLib(final ResourceSet resourceSet) {
    try {
      final URL url = this.getClass().getClassLoader().getResource(ParameterDefinitionDefaultLib.PARAMETER_LIB);
      final InputStream stream = url.openStream();
      final URI path = URI.createURI(url.getPath());
      final Resource resource = resourceSet.createResource(path);
      resource.load(stream, resourceSet.getLoadOptions());
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public ParameterSetDefinition getDefaultParameterSetObject(final EObject context) {
    final Function1<IEObjectDescription, Boolean> _function = (IEObjectDescription it) -> {
      String _string = it.getQualifiedName().toString();
      return Boolean.valueOf(Objects.equal(_string, ParameterDefinitionDefaultLib.DEFAULT_PARAMETR_SET));
    };
    final IEObjectDescription description = IterableExtensions.<IEObjectDescription>findFirst(this._parameterDefinitionIndex.getVisibleParameterSetDescriptions(context), _function);
    if ((description == null)) {
      return null;
    }
    EObject object = description.getEObjectOrProxy();
    boolean _eIsProxy = object.eIsProxy();
    if (_eIsProxy) {
      object = context.eResource().getResourceSet().getEObject(description.getEObjectURI(), true);
    }
    return ((ParameterSetDefinition) object);
  }
}
