/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.serviceDefinition.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.service.coordinationPattern.ParameterPattern;
import org.eclipse.smartmdsd.ecore.service.coordinationPattern.StatePattern;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.AbstractServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommRepoImport;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommunicationServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CoordinationServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefModel;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefRepository;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefinitionPackage;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceRepoVersion;
import org.eclipse.smartmdsd.xtext.base.docuterminals.formatting2.DocuTerminalsFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class ServiceDefinitionFormatter extends DocuTerminalsFormatter {
  protected void _format(final ServiceDefModel serviceDefModel, @Extension final IFormattableDocument document) {
    EList<CommRepoImport> _imports = serviceDefModel.getImports();
    for (final CommRepoImport commRepoImport : _imports) {
      {
        document.<CommRepoImport>format(commRepoImport);
        final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
          it.newLine();
        };
        document.<CommRepoImport>append(commRepoImport, _function);
      }
    }
    document.<ServiceDefRepository>format(serviceDefModel.getRepository());
  }
  
  protected void _format(final ServiceDefRepository serviceDefRepository, @Extension final IFormattableDocument document) {
    document.<ServiceRepoVersion>format(serviceDefRepository.getVersion());
    final ISemanticRegion ropen = this.textRegionExtensions.regionFor(serviceDefRepository).keyword("{");
    final ISemanticRegion rclose = this.textRegionExtensions.regionFor(serviceDefRepository).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(ropen, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(ropen, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(ropen, rclose, _function_2);
    final AbstractServiceDefinition lastElement = IterableExtensions.<AbstractServiceDefinition>last(serviceDefRepository.getServices());
    EList<AbstractServiceDefinition> _services = serviceDefRepository.getServices();
    for (final AbstractServiceDefinition serviceDefinition : _services) {
      {
        document.<AbstractServiceDefinition>format(serviceDefinition);
        final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
          it.oneSpace();
        };
        document.surround(this.textRegionExtensions.regionFor(serviceDefinition).feature(ServiceDefinitionPackage.Literals.ABSTRACT_SERVICE_DEFINITION__NAME), _function_3);
        if ((serviceDefinition == lastElement)) {
          final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
            it.newLine();
          };
          document.<AbstractServiceDefinition>append(serviceDefinition, _function_4);
        } else {
          final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
            it.setNewLines(2);
          };
          document.<AbstractServiceDefinition>append(serviceDefinition, _function_5);
        }
      }
    }
  }
  
  protected void _format(final CommunicationServiceDefinition serviceDefinition, @Extension final IFormattableDocument document) {
    final ISemanticRegion open = this.textRegionExtensions.regionFor(serviceDefinition).keyword("{");
    final ISemanticRegion close = this.textRegionExtensions.regionFor(serviceDefinition).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(open, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(open, close, _function_1);
  }
  
  protected void _format(final CoordinationServiceDefinition serviceDefinition, @Extension final IFormattableDocument document) {
    final ISemanticRegion open = this.textRegionExtensions.regionFor(serviceDefinition).keyword("{");
    final ISemanticRegion close = this.textRegionExtensions.regionFor(serviceDefinition).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(open, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(open, close, _function_1);
    ParameterPattern _parameterPattern = serviceDefinition.getParameterPattern();
    boolean _tripleNotEquals = (_parameterPattern != null);
    if (_tripleNotEquals) {
      final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
        it.newLine();
      };
      document.<ParameterPattern>append(serviceDefinition.getParameterPattern(), _function_2);
      document.<ParameterPattern>format(serviceDefinition.getParameterPattern());
    }
    StatePattern _statePattern = serviceDefinition.getStatePattern();
    boolean _tripleNotEquals_1 = (_statePattern != null);
    if (_tripleNotEquals_1) {
      final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
        it.newLine();
      };
      document.<StatePattern>append(serviceDefinition.getStatePattern(), _function_3);
      document.<StatePattern>format(serviceDefinition.getStatePattern());
    }
  }
  
  public void format(final Object serviceDefinition, final IFormattableDocument document) {
    if (serviceDefinition instanceof CommunicationServiceDefinition) {
      _format((CommunicationServiceDefinition)serviceDefinition, document);
      return;
    } else if (serviceDefinition instanceof CoordinationServiceDefinition) {
      _format((CoordinationServiceDefinition)serviceDefinition, document);
      return;
    } else if (serviceDefinition instanceof XtextResource) {
      _format((XtextResource)serviceDefinition, document);
      return;
    } else if (serviceDefinition instanceof ServiceDefRepository) {
      _format((ServiceDefRepository)serviceDefinition, document);
      return;
    } else if (serviceDefinition instanceof ServiceDefModel) {
      _format((ServiceDefModel)serviceDefinition, document);
      return;
    } else if (serviceDefinition instanceof EObject) {
      _format((EObject)serviceDefinition, document);
      return;
    } else if (serviceDefinition == null) {
      _format((Void)null, document);
      return;
    } else if (serviceDefinition != null) {
      _format(serviceDefinition, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(serviceDefinition, document).toString());
    }
  }
}
