/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ecore.system.deployment;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.deployment.ComponentArtefact;
import org.eclipse.smartmdsd.ecore.system.deployment.Deployment;
import org.eclipse.smartmdsd.ecore.system.deployment.DeploymentFactory;
import org.eclipse.smartmdsd.ecore.system.deployment.DeploymentModel;
import org.eclipse.smartmdsd.ecore.system.deployment.NamingService;
import org.eclipse.smartmdsd.ecore.system.deployment.NetworkInterfaceSelection;
import org.eclipse.smartmdsd.ecore.system.deployment.TargetPlatformReference;
import org.eclipse.smartmdsd.ecore.system.deployment.UploadDirectory;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.AbstractTPSubNode;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.NetworkInterface;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.TargetPlatformDefinition;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class DeploymentUtility {
    public static TargetPlatformReference addDefaultTargetReference(DeploymentModel deploymentModel, TargetPlatformDefinition targetDef) {
        TargetPlatformReference targetRef = DeploymentFactory.eINSTANCE.createTargetPlatformReference();
        targetRef.setName(targetDef.getName());
        targetRef.setPlatform(targetDef);
        Functions.Function1 _function = it -> it instanceof NetworkInterface;
        AbstractTPSubNode ni = (AbstractTPSubNode)IterableExtensions.findFirst((Iterable)targetDef.getElements(), (Functions.Function1)_function);
        if (ni instanceof NetworkInterface) {
            NetworkInterfaceSelection nis = DeploymentFactory.eINSTANCE.createNetworkInterfaceSelection();
            nis.setNetwork((NetworkInterface)ni);
            targetRef.setHost(nis);
        }
        UploadDirectory ud = DeploymentFactory.eINSTANCE.createUploadDirectory();
        ud.setPath("/tmp");
        targetRef.setDirectory(ud);
        deploymentModel.getElements().add((Object)targetRef);
        NamingService ns = DeploymentFactory.eINSTANCE.createNamingService();
        Deployment ns_depl = DeploymentFactory.eINSTANCE.createDeployment();
        ns_depl.setTo(targetRef);
        ns.setDeploy(ns_depl);
        deploymentModel.getElements().add((Object)ns);
        return targetRef;
    }

    public static boolean addComponentArtefact(DeploymentModel deploymentModel, ComponentInstance component, TargetPlatformReference targetRef) {
        boolean _xblockexpression = false;
        ComponentArtefact artefact = DeploymentFactory.eINSTANCE.createComponentArtefact();
        artefact.setComponent(component);
        artefact.setDeploy(DeploymentFactory.eINSTANCE.createDeployment());
        Deployment _deploy = artefact.getDeploy();
        _deploy.setTo(targetRef);
        _xblockexpression = deploymentModel.getElements().add((Object)artefact);
        return _xblockexpression;
    }

    public static void addAllMissingComponentArtefacts(DeploymentModel deploymentModel, TargetPlatformReference targetRef) {
        EList _components = deploymentModel.getComponentArch().getComponents();
        for (ComponentInstance component : _components) {
            boolean _not;
            Functions.Function1 _function = it -> {
                ComponentInstance _component = it.getComponent();
                return Objects.equal((Object)_component, (Object)component);
            };
            boolean _exists = IterableExtensions.exists((Iterable)Iterables.filter(deploymentModel.getElements(), ComponentArtefact.class), (Functions.Function1)_function);
            boolean bl = _not = !_exists;
            if (!_not) continue;
            DeploymentUtility.addComponentArtefact(deploymentModel, component, targetRef);
        }
    }

    public static boolean areAllComponentsDeployed(DeploymentModel deploymentModel) {
        EList _components = deploymentModel.getComponentArch().getComponents();
        for (ComponentInstance component : _components) {
            boolean _not;
            Functions.Function1 _function = it -> {
                ComponentInstance _component = it.getComponent();
                return Objects.equal((Object)_component, (Object)component);
            };
            boolean _exists = IterableExtensions.exists((Iterable)Iterables.filter(deploymentModel.getElements(), ComponentArtefact.class), (Functions.Function1)_function);
            boolean bl = _not = !_exists;
            if (!_not) continue;
            return false;
        }
        return true;
    }
}

