/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Matthias Lutz, Alex Lotz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.behavior.generator.domainModels;

import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommunicationServiceUsage;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CoordinationServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefinitionModelUtility;

@SuppressWarnings("all")
public class CoordinationInterfaceModelUtility extends ServiceDefinitionModelUtility {
  public static Collection<CommunicationObject> getAllCommObjects(final CommunicationServiceUsage commServiceUsage) {
    return ServiceDefinitionModelUtility.getAllCommObjects(commServiceUsage.getUses());
  }
  
  public static Collection<CommunicationObject> getAllCommObjects(final CoordinationServiceDefinition coordServiceDef) {
    final HashSet<CommunicationObject> objects = new HashSet<CommunicationObject>();
    final Consumer<CommunicationServiceUsage> _function = (CommunicationServiceUsage it) -> {
      objects.addAll(CoordinationInterfaceModelUtility.getAllCommObjects(it));
    };
    coordServiceDef.getServices().forEach(_function);
    return objects;
  }
}
