/********************************************************************************
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz
 ********************************************************************************/
package org.eclipse.smartmdsd.xtext.system.activityArchitecture.parser.antlr;

import com.google.inject.Inject;
import org.eclipse.smartmdsd.xtext.system.activityArchitecture.parser.antlr.internal.InternalActivityArchitectureParser;
import org.eclipse.smartmdsd.xtext.system.activityArchitecture.services.ActivityArchitectureGrammarAccess;
import org.eclipse.xtext.parser.antlr.AbstractAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;

public class ActivityArchitectureParser extends AbstractAntlrParser {

	@Inject
	private ActivityArchitectureGrammarAccess grammarAccess;

	@Override
	protected void setInitialHiddenTokens(XtextTokenStream tokenStream) {
		tokenStream.setInitialHiddenTokens("RULE_WS", "RULE_ML_COMMENT", "RULE_SL_COMMENT");
	}
	

	@Override
	protected InternalActivityArchitectureParser createParser(XtextTokenStream stream) {
		return new InternalActivityArchitectureParser(stream, getGrammarAccess());
	}

	@Override 
	protected String getDefaultRuleName() {
		return "ActivityArchitectureModel";
	}

	public ActivityArchitectureGrammarAccess getGrammarAccess() {
		return this.grammarAccess;
	}

	public void setGrammarAccess(ActivityArchitectureGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}
}
