/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.system.activityArchitecture.validation;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ActivityArchitecturePackage;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ExecutionTime;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.TimeUnit;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.TimeValue;
import org.eclipse.smartmdsd.xtext.system.activityArchitecture.validation.AbstractActivityArchitectureValidator;
import org.eclipse.xtext.validation.Check;

public class ActivityArchitectureValidator
extends AbstractActivityArchitectureValidator {
    public static final String ACT_ARCH_PACKAGE = "org.xtext.system.activityArchitecture.";
    public static final String MAX_EXEC_TIME = "org.xtext.system.activityArchitecture.MaxMaxExecTime";
    public static final String MIN_EXEC_TIME = "org.xtext.system.activityArchitecture.MinMaxExecTime";

    @Check
    public void checkExecutionTimeValues(ExecutionTime exec) {
        if (exec.getMinTime() != null && exec.getMaxTime() != null) {
            double _time_1;
            boolean _greaterThan;
            double _time = this.getTime(exec.getMinTime());
            boolean bl = _greaterThan = _time > (_time_1 = this.getTime(exec.getMaxTime()));
            if (_greaterThan) {
                this.error("MIN execution time is higher than the MAX execution time", (EStructuralFeature)ActivityArchitecturePackage.Literals.EXECUTION_TIME__MIN_TIME, MIN_EXEC_TIME, new String[0]);
                this.error("MAX execution time is lower than the MIN execution time", (EStructuralFeature)ActivityArchitecturePackage.Literals.EXECUTION_TIME__MAX_TIME, MAX_EXEC_TIME, new String[0]);
            }
        }
    }

    private double getTime(TimeValue tv) {
        double result = 0.0;
        TimeUnit _unit = tv.getUnit();
        if (_unit != null) {
            switch (_unit) {
                case SEC: {
                    result = tv.getValue();
                    break;
                }
                case MSEC: {
                    double _divide;
                    int _value = tv.getValue();
                    result = _divide = (double)_value / 1000.0;
                    break;
                }
                case USEC: {
                    double _divide_2;
                    int _value_1 = tv.getValue();
                    double _divide_1 = (double)_value_1 / 1000.0;
                    result = _divide_2 = _divide_1 / 1000.0;
                    break;
                }
            }
        }
        return result;
    }
}

