/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.system.componentArchitecture.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.SupportedMiddleware;
import org.eclipse.smartmdsd.ecore.service.roboticMiddleware.RoboticMiddleware;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentArchitectureModelUtility;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentArchitecturePackage;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.Connection;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ProvidedService;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.RequiredService;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ServiceInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.SystemComponentArchitecture;
import org.eclipse.smartmdsd.ecore.system.systemParameter.ComponentParameterInstance;
import org.eclipse.smartmdsd.ecore.system.systemParameter.ParameterStructInstance;
import org.eclipse.smartmdsd.ecore.system.systemParameter.SystemParamModel;
import org.eclipse.smartmdsd.ecore.system.systemParameter.SystemParameterPackage;
import org.eclipse.smartmdsd.xtext.system.componentArchitecture.validation.AbstractComponentArchitectureValidator;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ComponentArchitectureValidator
extends AbstractComponentArchitectureValidator {
    @Inject
    private IQualifiedNameProvider fqn_provider;
    protected static final String COMP_ARCH_ISSUE_PREFIX = "org.xtext.system.componentArchitecture.";
    public static final String INVALID_COMP_NAME = "org.xtext.system.componentArchitecture.InvalidName";
    public static final String INCOMPATIBLE_SERVICE = "org.xtext.system.componentArchitecture.IncompatibleService";
    public static final String MISSING_PORTS = "org.xtext.system.componentArchitecture.MissingPorts";
    public static final String NOT_CONNECTED_SERVICE = "org.xtext.system.componentArchitecture.NotConenctedService";
    public static final String MIDDLWARE_SELECTION_NOT_SUPPORTED = "org.xtext.system.componentArchitecture.MiddlewareSelectionNotSupported";
    public static final String CONFLICTING_MIDDLWARE_SELECTION = "org.xtext.system.componentArchitecture.ConflictingMiddlewareSelection";
    public static final String DUPLICATE_PARAMETER_STRUCT = "org.xtext.system.componentArchitecture.DuplicateParameterStruct";
    public static final String INVALID_PARAMETER_STRUCT = "org.xtext.system.componentArchitecture.InvalidParameterStruct";

    @Check
    public void checkCompNameStartsWithCapital(ComponentInstance comp) {
        boolean _not;
        boolean _isUpperCase = Character.isUpperCase(comp.getName().charAt(0));
        boolean bl = _not = !_isUpperCase;
        if (_not) {
            this.warning("Name should start with a capital", (EStructuralFeature)ComponentArchitecturePackage.Literals.COMPONENT_INSTANCE__NAME, INVALID_COMP_NAME, new String[0]);
        }
    }

    @Check
    public void checkServiceCompatibility(Connection connection) {
        boolean _equals;
        boolean _servicePortsCompatible = ComponentArchitectureModelUtility.servicePortsCompatible((ServiceInstance)connection.getFrom(), (ServiceInstance)connection.getTo());
        boolean bl = _equals = !_servicePortsCompatible;
        if (_equals) {
            this.error("Connected to an incompatible service provider.", (EStructuralFeature)ComponentArchitecturePackage.Literals.CONNECTION__TO, INCOMPATIBLE_SERVICE, new String[0]);
        }
    }

    @Check
    public void checkAllRequiredPortsInstantiated(ComponentInstance component) {
        boolean _not;
        Functions.Function1 _function;
        Iterable services = ComponentArchitectureModelUtility.getNonOptionalClientPorts((ComponentInstance)component);
        boolean _forall = IterableExtensions.forall((Iterable)services, (Functions.Function1)(_function = svc -> {
            Functions.Function1 _function_1 = it -> {
                ComponentPort _port = it.getPort();
                return Objects.equal((Object)_port, (Object)svc);
            };
            return IterableExtensions.exists((Iterable)component.getPorts(), (Functions.Function1)_function_1);
        }));
        boolean bl = _not = !_forall;
        if (_not) {
            this.warning("Some non-optional component-ports have not been instantiated!", (EStructuralFeature)ComponentArchitecturePackage.Literals.COMPONENT_INSTANCE__NAME, MISSING_PORTS, new String[0]);
        }
    }

    @Check
    public void checkRequiredPortConnected(RequiredService svc) {
        EObject parent = svc.eContainer().eContainer();
        if (parent instanceof SystemComponentArchitecture) {
            boolean _not;
            Functions.Function1 _function = it -> {
                RequiredService _from = it.getFrom();
                return Objects.equal((Object)_from, (Object)svc);
            };
            boolean _exists = IterableExtensions.exists((Iterable)((SystemComponentArchitecture)parent).getConnections(), (Functions.Function1)_function);
            boolean bl = _not = !_exists;
            if (_not) {
                this.warning("RequiredService has not yet been connected to any ProvidedService!", (EStructuralFeature)ComponentArchitecturePackage.Literals.SERVICE_INSTANCE__PORT, NOT_CONNECTED_SERVICE, new String[0]);
            }
        }
    }

    @Check
    public void checkSupportedMiddlewareSelection(Connection connection) {
        boolean _tripleNotEquals;
        RoboticMiddleware _middlewareSelection = connection.getMiddlewareSelection();
        boolean bl = _tripleNotEquals = _middlewareSelection != null;
        if (_tripleNotEquals) {
            boolean _not_1;
            boolean _not;
            Functions.Function1 _function = it -> {
                EClass _eClass = it.getMiddleware().eClass();
                EClass _eClass_1 = connection.getMiddlewareSelection().eClass();
                return Objects.equal((Object)_eClass, (Object)_eClass_1);
            };
            boolean _exists = IterableExtensions.exists((Iterable)Iterables.filter((Iterable)connection.getFrom().getPort().getExtensions(), SupportedMiddleware.class), (Functions.Function1)_function);
            boolean bl2 = _not = !_exists;
            if (_not) {
                String _name = connection.getMiddlewareSelection().eClass().getName();
                String _plus = "Selected middleware " + _name;
                String _plus_1 = String.valueOf(_plus) + " is not supported by the required service ";
                String _name_1 = connection.getFrom().getName();
                String _plus_2 = String.valueOf(_plus_1) + _name_1;
                this.error(_plus_2, (EStructuralFeature)ComponentArchitecturePackage.Literals.CONNECTION__MIDDLEWARE_SELECTION, MIDDLWARE_SELECTION_NOT_SUPPORTED, new String[0]);
            }
            Functions.Function1 _function_1 = it -> {
                EClass _eClass = it.getMiddleware().eClass();
                EClass _eClass_1 = connection.getMiddlewareSelection().eClass();
                return Objects.equal((Object)_eClass, (Object)_eClass_1);
            };
            boolean _exists_1 = IterableExtensions.exists((Iterable)Iterables.filter((Iterable)connection.getTo().getPort().getExtensions(), SupportedMiddleware.class), (Functions.Function1)_function_1);
            boolean bl3 = _not_1 = !_exists_1;
            if (_not_1) {
                String _name_2 = connection.getMiddlewareSelection().eClass().getName();
                String _plus_3 = "Selected middleware " + _name_2;
                String _plus_4 = String.valueOf(_plus_3) + " is not supported by the provided service ";
                String _name_3 = connection.getTo().getName();
                String _plus_5 = String.valueOf(_plus_4) + _name_3;
                this.error(_plus_5, (EStructuralFeature)ComponentArchitecturePackage.Literals.CONNECTION__MIDDLEWARE_SELECTION, MIDDLWARE_SELECTION_NOT_SUPPORTED, new String[0]);
            }
        }
    }

    @Check
    public void checkConflictingMiddlewareSelection(Connection connection) {
        EObject parent;
        boolean _tripleNotEquals;
        RoboticMiddleware _middlewareSelection = connection.getMiddlewareSelection();
        boolean bl = _tripleNotEquals = _middlewareSelection != null;
        if (_tripleNotEquals && (parent = connection.eContainer()) instanceof SystemComponentArchitecture) {
            EList _connections = ((SystemComponentArchitecture)parent).getConnections();
            for (Connection other : _connections) {
                EClass _eClass_1;
                boolean _notEquals_1;
                boolean _tripleNotEquals_1;
                ProvidedService _to_1;
                ProvidedService _to;
                boolean _equals;
                boolean _notEquals;
                boolean bl2 = _notEquals = !Objects.equal((Object)connection, (Object)other);
                if (!_notEquals || !(_equals = Objects.equal((Object)(_to = connection.getTo()), (Object)(_to_1 = other.getTo())))) continue;
                RoboticMiddleware _middlewareSelection_1 = other.getMiddlewareSelection();
                boolean bl3 = _tripleNotEquals_1 = _middlewareSelection_1 != null;
                if (!_tripleNotEquals_1) continue;
                EClass _eClass = connection.getMiddlewareSelection().eClass();
                boolean bl4 = _notEquals_1 = !Objects.equal((Object)_eClass, (Object)(_eClass_1 = other.getMiddlewareSelection().eClass()));
                if (!_notEquals_1) continue;
                String _name = connection.getMiddlewareSelection().eClass().getName();
                String _plus = "Selected middleware " + _name;
                String _plus_1 = String.valueOf(_plus) + " conflicts with another selection for the same service ";
                String _name_1 = connection.getTo().getName();
                String _plus_2 = String.valueOf(_plus_1) + _name_1;
                this.error(_plus_2, (EStructuralFeature)ComponentArchitecturePackage.Literals.CONNECTION__MIDDLEWARE_SELECTION, CONFLICTING_MIDDLWARE_SELECTION, new String[0]);
            }
        }
    }

    @Check
    public void checkSingleParamStruct(ParameterStructInstance param) {
        EObject parent = param.eContainer();
        if (parent instanceof ComponentInstance) {
            boolean _greaterThan;
            int _size = IterableExtensions.size((Iterable)Iterables.filter((Iterable)((ComponentInstance)parent).getExtensions(), ParameterStructInstance.class));
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                this.error("Multiple ParameterStructs defined, but at most one is allowed.", (EStructuralFeature)SystemParameterPackage.Literals.PARAMETER_STRUCT_INSTANCE__PARAMETER, DUPLICATE_PARAMETER_STRUCT, new String[0]);
            }
        }
    }

    @Check
    public void checkCompatibleParamStruct(ParameterStructInstance paramInstance) {
        EObject compInstance = paramInstance.eContainer();
        if (compInstance instanceof ComponentInstance) {
            boolean _equals_1;
            boolean _not;
            EObject paramModel = paramInstance.getParameter().eContainer();
            String fqn = "";
            if (paramModel instanceof SystemParamModel) {
                EList _components = ((SystemParamModel)paramModel).getComponents();
                for (ComponentParameterInstance param : _components) {
                    boolean _equals = param.getComponentInstance().equals(compInstance);
                    if (!_equals) continue;
                    fqn = this.fqn_provider.getFullyQualifiedName((EObject)param).toString();
                }
            }
            boolean bl = _not = !(_equals_1 = paramInstance.getParameter().getComponentInstance().equals(compInstance));
            if (_not) {
                this.error("Invalid ComponentParameterInstance.", (EStructuralFeature)SystemParameterPackage.Literals.PARAMETER_STRUCT_INSTANCE__PARAMETER, INVALID_PARAMETER_STRUCT, new String[]{fqn});
            }
        }
    }
}

