/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.system.deployment.ui.quickfix;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.deployment.AbstractDeploymentElement;
import org.eclipse.smartmdsd.ecore.system.deployment.DeploymentFactory;
import org.eclipse.smartmdsd.ecore.system.deployment.DeploymentModel;
import org.eclipse.smartmdsd.ecore.system.deployment.DeploymentUtility;
import org.eclipse.smartmdsd.ecore.system.deployment.NetworkInterfaceSelection;
import org.eclipse.smartmdsd.ecore.system.deployment.TargetPlatformReference;
import org.eclipse.smartmdsd.ecore.system.deployment.UploadDirectory;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.NetworkInterface;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.TargetPlatformDefinition;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.TargetPlatformPackage;
import org.eclipse.smartmdsd.xtext.indexer.XtextResourceIndex;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class DeploymentQuickfixProvider
extends DefaultQuickfixProvider {
    @Inject
    private XtextResourceIndex index;

    @Fix(value="org.xtext.system.deployment.MultipleNamingServices")
    public void fixDuplicateOperationModeBinding(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            EObject _eContainer = element.eContainer();
            DeploymentModel model = (DeploymentModel)_eContainer;
            model.getElements().remove((Object)element);
        };
        acceptor.accept(issue, "Remove duplicate NamingService", "Remove duplicate NamingService.", "", _function);
    }

    @Fix(value="org.xtext.system.deployment.MissingUploadDirectory")
    public void fixMissingUploadDirectoy(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            TargetPlatformReference platform = (TargetPlatformReference)element;
            platform.setDirectory(DeploymentFactory.eINSTANCE.createUploadDirectory());
            UploadDirectory _directory = platform.getDirectory();
            _directory.setPath("/tmp");
        };
        acceptor.accept(issue, "Create a default UploadDirectory", "Create a default UploadDirectory", "", _function);
    }

    @Fix(value="org.xtext.system.deployment.MissingNetworkInterface")
    public void fixMissingNetworkInterface(Issue issue, IssueResolutionAcceptor acceptor) {
        EObject object = this.getEObject(issue);
        if (object instanceof TargetPlatformReference) {
            Iterable _filter = Iterables.filter((Iterable)((TargetPlatformReference)object).getPlatform().getElements(), NetworkInterface.class);
            for (NetworkInterface network : _filter) {
                String _name = network.getName();
                String _plus = "Use the NetworkInterface " + _name;
                String _name_1 = network.getName();
                String _plus_1 = "Use the NetworkInterface " + _name_1;
                ISemanticModification _function = (element, context) -> {
                    TargetPlatformReference platform = (TargetPlatformReference)element;
                    platform.setHost(DeploymentFactory.eINSTANCE.createNetworkInterfaceSelection());
                    NetworkInterfaceSelection _host = platform.getHost();
                    _host.setNetwork(network);
                };
                acceptor.accept(issue, _plus, _plus_1, "", _function);
            }
        }
    }

    @Fix(value="org.xtext.system.deployment.NoTargetPlatformsDefined")
    public void addDefaultDeployment(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            EObject target;
            EObject object;
            boolean _eIsProxy;
            boolean _not;
            DeploymentModel model = (DeploymentModel)element;
            Iterable targets = this.index.getVisibleEObjectDescriptions((EObject)model, TargetPlatformPackage.eINSTANCE.getTargetPlatformDefinition());
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)targets);
            boolean bl = _not = !_isEmpty;
            if (_not && (_eIsProxy = (object = ((IEObjectDescription)IterableExtensions.head((Iterable)targets)).getEObjectOrProxy()).eIsProxy()) && (target = EcoreUtil.resolve((EObject)object, (EObject)model)) instanceof TargetPlatformDefinition) {
                TargetPlatformReference ref = DeploymentUtility.addDefaultTargetReference((DeploymentModel)model, (TargetPlatformDefinition)((TargetPlatformDefinition)target));
                DeploymentUtility.addAllMissingComponentArtefacts((DeploymentModel)model, (TargetPlatformReference)ref);
            }
        };
        acceptor.accept(issue, "Add default deployment target", "Add default deployment target", "", _function);
    }

    private EObject getEObject(final Issue issue) {
        IModificationContext modificationContext = this.getModificationContextFactory().createModificationContext(issue);
        IXtextDocument xtextDocument = modificationContext.getXtextDocument();
        EObject object = (EObject)xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<EObject, XtextResource>(){

            public EObject exec(XtextResource state) throws Exception {
                return state.getEObject(issue.getUriToProblem().fragment());
            }
        });
        return object;
    }

    @Fix(value="org.xtext.system.deployment.MissingComponentArtefact")
    public void createMissingComponentArtefact(Issue issue, IssueResolutionAcceptor acceptor) {
        String _get = issue.getData()[0];
        String _plus = "Create missing component-artefact " + _get;
        String _get_1 = issue.getData()[0];
        String _plus_1 = "Create missing component-artefact " + _get_1;
        ISemanticModification _function = (element, context) -> {
            DeploymentModel model = (DeploymentModel)element;
            Functions.Function1 _function_1 = it -> it instanceof TargetPlatformReference;
            AbstractDeploymentElement target = (AbstractDeploymentElement)IterableExtensions.findFirst((Iterable)model.getElements(), (Functions.Function1)_function_1);
            if (target instanceof TargetPlatformReference) {
                Functions.Function1 _function_2 = it -> {
                    String _name = it.getName();
                    String _get_2 = issue.getData()[0];
                    return Objects.equal((Object)_name, (Object)_get_2);
                };
                ComponentInstance component = (ComponentInstance)IterableExtensions.findFirst((Iterable)model.getComponentArch().getComponents(), (Functions.Function1)_function_2);
                if (component != null) {
                    DeploymentUtility.addComponentArtefact((DeploymentModel)model, (ComponentInstance)component, (TargetPlatformReference)((TargetPlatformReference)target));
                }
            }
        };
        acceptor.accept(issue, _plus, _plus_1, "", _function);
    }
}

