/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.service.communicationObject;

import com.google.common.base.Objects;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesFactory;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesTypeConformance;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationElement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.SingleValue;
import org.eclipse.smartmdsd.ecore.service.communicationObject.AbstractCommElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommElementReference;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommElementValue;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObjectFactory;
import org.eclipse.smartmdsd.ecore.service.communicationObject.Enumeration;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class CommunicationObjectTypeConformance extends BasicAttributesTypeConformance {
  @Override
  public AbstractValue createPrimitiveDefaultValue(final AbstractAttributeType attrType) {
    AbstractValue _xblockexpression = null;
    {
      SingleValue value = null;
      AbstractValue _xifexpression = null;
      if ((attrType instanceof CommElementReference)) {
        final AbstractCommElement typeName = ((CommElementReference)attrType).getTypeName();
        if ((typeName instanceof CommunicationObject)) {
          final CommElementValue commElemValue = CommunicationObjectFactory.eINSTANCE.createCommElementValue();
          commElemValue.setValue(typeName);
          value = commElemValue;
        } else {
          if ((typeName instanceof Enumeration)) {
            final EnumerationValue en = BasicAttributesFactory.eINSTANCE.createEnumerationValue();
            en.setValue(IterableExtensions.<EnumerationElement>head(((Enumeration)typeName).getEnums()));
            value = en;
          }
        }
        ArrayType _array = ((CommElementReference)attrType).getArray();
        boolean _tripleNotEquals = (_array != null);
        if (_tripleNotEquals) {
          final ArrayValue arrayValue = BasicAttributesFactory.eINSTANCE.createArrayValue();
          if ((value != null)) {
            arrayValue.getValues().add(value);
          }
          return arrayValue;
        } else {
          return value;
        }
      } else {
        _xifexpression = super.createPrimitiveDefaultValue(attrType);
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  @Override
  protected boolean checkCompatibility(final AbstractAttributeType attrType, final AbstractValue av) {
    boolean compatible = false;
    if ((attrType instanceof CommElementReference)) {
      final AbstractCommElement refType = ((CommElementReference)attrType).getTypeName();
      if ((refType instanceof Enumeration)) {
        if ((av instanceof EnumerationValue)) {
          final Function1<EnumerationElement, Boolean> _function = (EnumerationElement it) -> {
            String _name = it.getName();
            String _name_1 = ((EnumerationValue)av).getValue().getName();
            return Boolean.valueOf(Objects.equal(_name, _name_1));
          };
          compatible = IterableExtensions.<EnumerationElement>exists(((Enumeration)refType).getEnums(), _function);
        }
      } else {
        if ((refType instanceof CommunicationObject)) {
          if ((av instanceof CommElementValue)) {
            String _name = ((CommElementValue)av).getValue().getName();
            String _name_1 = ((CommElementReference)attrType).getTypeName().getName();
            boolean _equals = Objects.equal(_name, _name_1);
            compatible = _equals;
          }
        }
      }
    } else {
      compatible = super.checkCompatibility(attrType, av);
    }
    return compatible;
  }
  
  @Override
  public String getValueTypeName(final AbstractValue av) {
    String _xifexpression = null;
    if ((av instanceof CommElementValue)) {
      String _name = ((CommElementValue)av).getValue().getName();
      String _plus = ("\'" + _name);
      _xifexpression = (_plus + "\'");
    } else {
      _xifexpression = super.getValueTypeName(av);
    }
    return _xifexpression;
  }
  
  @Override
  public String getCardinalityName(final AbstractAttributeType attrType) {
    String _xifexpression = null;
    if ((attrType instanceof CommElementReference)) {
      String _xifexpression_1 = null;
      ArrayType _array = ((CommElementReference)attrType).getArray();
      boolean _tripleNotEquals = (_array != null);
      if (_tripleNotEquals) {
        String _name = ((CommElementReference)attrType).getTypeName().getName();
        String _plus = ("an array of type \'" + _name);
        _xifexpression_1 = (_plus + "\'");
      } else {
        String _name_1 = ((CommElementReference)attrType).getTypeName().getName();
        String _plus_1 = ("an element of type \'" + _name_1);
        _xifexpression_1 = (_plus_1 + "\'");
      }
      _xifexpression = _xifexpression_1;
    } else {
      _xifexpression = super.getCardinalityName(attrType);
    }
    return _xifexpression;
  }
}
