/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.service.communicationObject;

import com.google.common.collect.Iterables;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesModelUtility;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationValue;
import org.eclipse.smartmdsd.ecore.service.communicationObject.AbstractCommElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommElementReference;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommElementValue;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.communicationObject.Enumeration;

@SuppressWarnings("all")
public class CommunicationObjectUtility extends BasicAttributesModelUtility {
  @Override
  public String getValueString(final AbstractValue av) {
    String _xifexpression = null;
    if ((av instanceof EnumerationValue)) {
      return ((EnumerationValue)av).getValue().getName();
    } else {
      String _xifexpression_1 = null;
      if ((av instanceof CommElementValue)) {
        return ((CommElementValue)av).getValue().getName();
      } else {
        _xifexpression_1 = super.getValueString(av);
      }
      _xifexpression = _xifexpression_1;
    }
    return _xifexpression;
  }
  
  @Override
  public String getTypeName(final AbstractAttributeType attrType) {
    String _xifexpression = null;
    if ((attrType instanceof CommElementReference)) {
      return ((CommElementReference)attrType).getTypeName().getName();
    } else {
      _xifexpression = super.getTypeName(attrType);
    }
    return _xifexpression;
  }
  
  public boolean isComposedType(final AbstractAttributeType attrType) {
    if ((attrType instanceof CommElementReference)) {
      AbstractCommElement _typeName = ((CommElementReference)attrType).getTypeName();
      return (_typeName instanceof CommunicationObject);
    }
    return false;
  }
  
  public boolean isCommunicationObject(final AbstractAttributeType attrType) {
    if ((attrType instanceof CommElementReference)) {
      AbstractCommElement _typeName = ((CommElementReference)attrType).getTypeName();
      boolean _matched = false;
      if (_typeName instanceof CommunicationObject) {
        _matched=true;
        return true;
      }
    }
    return false;
  }
  
  public boolean isEnumeration(final AbstractAttributeType attrType) {
    if ((attrType instanceof CommElementReference)) {
      AbstractCommElement _typeName = ((CommElementReference)attrType).getTypeName();
      boolean _matched = false;
      if (_typeName instanceof Enumeration) {
        _matched=true;
        return true;
      }
    }
    return false;
  }
  
  public CommunicationObject getCommunicationObjectRef(final AbstractAttributeType attrType) {
    if ((attrType instanceof CommElementReference)) {
      final AbstractCommElement typeName = ((CommElementReference)attrType).getTypeName();
      boolean _matched = false;
      if (typeName instanceof CommunicationObject) {
        _matched=true;
        return ((CommunicationObject)typeName);
      }
    }
    return null;
  }
  
  public Iterable<CommunicationObject> getCommunicationObjects(final CommObjectsRepository repo) {
    return Iterables.<CommunicationObject>filter(repo.getElements(), CommunicationObject.class);
  }
  
  public Iterable<Enumeration> getEnumerations(final CommObjectsRepository repo) {
    return Iterables.<Enumeration>filter(repo.getElements(), Enumeration.class);
  }
}
