/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.models;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.smartmdsd.ui.models.ISmartMDSDSiriusContribution;
import org.eclipse.smartmdsd.ui.models.ISmartMDSDXtextContribution;
import org.eclipse.smartmdsd.ui.models.SmartMDSDModelingLanguage;
import org.eclipse.smartmdsd.ui.natures.SmartMDSDNatureEnum;

public class SmartMDSDModelingLanguageRegistry {
    private Map<String, SmartMDSDModelingLanguage> language_registry = new HashMap<String, SmartMDSDModelingLanguage>();

    public SmartMDSDModelingLanguageRegistry(SmartMDSDNatureEnum nature) {
        this.createRegistry(nature);
    }

    public Collection<SmartMDSDModelingLanguage> getAllLanguages() {
        return this.language_registry.values();
    }

    public Collection<String> getLanguageNames() {
        return this.language_registry.keySet();
    }

    public SmartMDSDModelingLanguage getLanguage(String languageName) {
        return this.language_registry.get(languageName);
    }

    public SmartMDSDModelingLanguage getLanguage(EPackage epackage) {
        return this.language_registry.get(epackage.getName());
    }

    public SmartMDSDModelingLanguage getLanguageFrom(String xtextEditorID) {
        for (SmartMDSDModelingLanguage language : this.language_registry.values()) {
            if (!language.getXtextEditorID().contentEquals(xtextEditorID)) continue;
            return language;
        }
        return null;
    }

    private void createRegistry(SmartMDSDNatureEnum nature) {
        IConfigurationElement[] configurations = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.smartmdsd.ui.SmartMDSDModelContributionEP");
        try {
            Object object;
            IConfigurationElement config;
            IConfigurationElement[] iConfigurationElementArray = configurations;
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                ISmartMDSDXtextContribution xtextDSL;
                config = iConfigurationElementArray[n2];
                object = config.createExecutableExtension("class");
                if (object instanceof ISmartMDSDXtextContribution && (xtextDSL = (ISmartMDSDXtextContribution)object).getSmartMDSDNatureEnum().equals((Object)nature)) {
                    String nature_name = nature.name();
                    String languageName = xtextDSL.getEPackage().getName();
                    if (this.language_registry.containsKey(languageName)) {
                        System.err.println("SmartMDSD modeling-language with the name " + languageName + " exists in the nature " + nature_name + ". The modeling-language mapping will be overridden!");
                    }
                    System.out.println("Register SmartMDSD modeling-language " + languageName + " with nature " + nature_name);
                    this.language_registry.put(languageName, new SmartMDSDModelingLanguage(xtextDSL));
                }
                ++n2;
            }
            iConfigurationElementArray = configurations;
            n = configurations.length;
            n2 = 0;
            while (n2 < n) {
                SmartMDSDModelingLanguage language;
                ISmartMDSDSiriusContribution siriusContribution;
                config = iConfigurationElementArray[n2];
                object = config.createExecutableExtension("class");
                if (object instanceof ISmartMDSDSiriusContribution && (siriusContribution = (ISmartMDSDSiriusContribution)object).getSmartMDSDNatureEnum().equals((Object)nature) && (language = this.getLanguage(siriusContribution.getEPackage())) != null) {
                    System.out.println("Add Sirius viewpoint " + siriusContribution.getViewpointName() + " to language " + language.getLanguageName());
                    language.setSiriusViewpoint(siriusContribution);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

