/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.service.serviceDefinition.ui.quickfix;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.smartmdsd.ecore.service.coordinationPattern.CoordinationPatternFactory;
import org.eclipse.smartmdsd.ecore.service.coordinationPattern.ParameterPattern;
import org.eclipse.smartmdsd.ecore.service.coordinationPattern.StatePattern;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CoordinationServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefRepository;
import org.eclipse.smartmdsd.xtext.base.stateMachine.StateMachineDefaultLifecycleLib;
import org.eclipse.smartmdsd.xtext.service.parameterDefinition.ParameterDefinitionDefaultLib;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class ServiceDefinitionQuickfixProvider
extends DefaultQuickfixProvider {
    @Inject
    private ParameterDefinitionDefaultLib paramLib;
    @Inject
    private StateMachineDefaultLifecycleLib stateLib;

    @Fix(value="org.xtext.service.serviceDefinition.MissingParameterPattern")
    public void missingParameterPattern(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            CoordinationServiceDefinition service = (CoordinationServiceDefinition)element;
            ParameterPattern parameter = CoordinationPatternFactory.eINSTANCE.createParameterPattern();
            parameter.setParameterSet(this.paramLib.getDefaultParameterSetObject((EObject)service));
            service.setParameterPattern(parameter);
        };
        acceptor.accept(issue, "Add default ParameterPattern definition", "Add default ParameterPattern definition that uses the EmptyDefaultParameterSet", "", _function);
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof XtextEditor) {
            ISourceViewer _internalSourceViewer = ((XtextEditor)editor).getInternalSourceViewer();
            ((SourceViewer)_internalSourceViewer).doOperation(15);
        }
    }

    @Fix(value="org.xtext.service.serviceDefinition.MissingStatePattern")
    public void missingStatePattern(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            CoordinationServiceDefinition service = (CoordinationServiceDefinition)element;
            service.setStatePattern(CoordinationPatternFactory.eINSTANCE.createStatePattern());
            StatePattern _statePattern = service.getStatePattern();
            _statePattern.setLifecycle(this.stateLib.getDefaultComponentLifecycleObject((EObject)service));
        };
        acceptor.accept(issue, "Add default StatePattern definition", "Add default StatePattern definition that uses the default ComponentLifecycle", "", _function);
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof XtextEditor) {
            ISourceViewer _internalSourceViewer = ((XtextEditor)editor).getInternalSourceViewer();
            ((SourceViewer)_internalSourceViewer).doOperation(15);
        }
    }

    @Fix(value="org.xtext.service.serviceDefinition.InvalidRepoName")
    public void repoName(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> ((ServiceDefRepository)element).setName(issue.getData()[0]);
        acceptor.accept(issue, "Fix repository name to match project name", "Repository name will be set to project name", "", _function);
    }

    @Fix(value="org.xtext.service.serviceDefinition.CapitalServiceName")
    public void capitalizeName(Issue issue, IssueResolutionAcceptor acceptor) {
        IModification _function = context -> {
            IXtextDocument xtextDocument = context.getXtextDocument();
            String firstLetter = xtextDocument.get(issue.getOffset().intValue(), 1);
            xtextDocument.replace(issue.getOffset().intValue(), 1, firstLetter.toUpperCase());
        };
        acceptor.accept(issue, "Capitalize name", "Capitalize the name.", "", _function);
    }
}

