/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNode;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParametersRef;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.ExtendedOutputConfigurationProvider;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.ComponentCMakeGenerator;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.InteractionObserver;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartComponent;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartComponentExtension;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartComponentPortFactory;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartEventHandler;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartHandlerState;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartIniParameter;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartInputHandler;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartQueryHandler;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartTask;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.params.ComponentParamsGenerator2;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@SuppressWarnings("all")
public class ComponentGenerator2Impl extends AbstractGenerator {
  @Inject
  @Extension
  private SmartComponent _smartComponent;
  
  @Inject
  @Extension
  private ComponentCMakeGenerator _componentCMakeGenerator;
  
  @Inject
  @Extension
  private CopyrightHelpers _copyrightHelpers;
  
  @Inject
  @Extension
  private SmartTask _smartTask;
  
  @Inject
  @Extension
  private SmartHandlerState _smartHandlerState;
  
  @Inject
  @Extension
  private SmartIniParameter _smartIniParameter;
  
  @Inject
  @Extension
  private SmartEventHandler _smartEventHandler;
  
  @Inject
  @Extension
  private SmartInputHandler _smartInputHandler;
  
  @Inject
  @Extension
  private SmartQueryHandler _smartQueryHandler;
  
  @Inject
  @Extension
  private InteractionObserver _interactionObserver;
  
  @Inject
  @Extension
  private SmartComponentPortFactory _smartComponentPortFactory;
  
  @Inject
  @Extension
  private SmartComponentExtension _smartComponentExtension;
  
  @Inject
  private ComponentParamsGenerator2 paramGenerator;
  
  @Override
  public void doGenerate(final Resource input, final IFileSystemAccess2 fsa, final IGeneratorContext context) {
    Iterable<ComponentDefinition> _filter = Iterables.<ComponentDefinition>filter(IteratorExtensions.<EObject>toIterable(input.getAllContents()), ComponentDefinition.class);
    for (final ComponentDefinition comp : _filter) {
      {
        fsa.generateFile("info.txt", this.compileToolchainVersionFile(comp));
        Iterable<ComponentParametersRef> _filter_1 = Iterables.<ComponentParametersRef>filter(comp.getElements(), ComponentParametersRef.class);
        for (final ComponentParametersRef param : _filter_1) {
          this.paramGenerator.doGenerate(param.getParameter().eResource(), fsa, context);
        }
        final CharSequence iniFileHeadContent = this._smartIniParameter.CreateIniFile(comp);
        fsa.generateFile(this._smartComponent.getParameterIniFileName(comp), iniFileHeadContent);
        String _name = comp.getName();
        final String bottominiFileName = (_name + ".ini.bottom");
        boolean _isFile = fsa.isFile(bottominiFileName, ExtendedOutputConfigurationProvider.SRC_GEN_PARAMS);
        if (_isFile) {
          final String iniFileBottomContent = fsa.readTextFile(bottominiFileName, ExtendedOutputConfigurationProvider.SRC_GEN_PARAMS).toString();
          String _name_1 = comp.getName();
          String _plus = (_name_1 + ".ini.template");
          String _plus_1 = (iniFileHeadContent + iniFileBottomContent);
          fsa.generateFile(_plus, _plus_1);
        }
        fsa.generateFile("main.cc", this._smartComponent.MainFileContent(comp));
        fsa.generateFile(this._smartComponentPortFactory.getPortFactoryInterfaceFilename(comp), this._smartComponentPortFactory.compilePortFactoryInterface(comp));
        fsa.generateFile(this._smartComponentPortFactory.getAcePortFactoryHeaderFilename(comp), this._smartComponentPortFactory.compileAcePortFactoryHeader(comp));
        fsa.generateFile(this._smartComponentPortFactory.getAcePortFactorySourceFilename(comp), this._smartComponentPortFactory.compileAcePortFactorySource(comp));
        fsa.generateFile(this._smartComponentExtension.getComponentExtensionHeaderFilename(comp), this._smartComponentExtension.compileComponentExtensionHeader(comp));
        fsa.generateFile(this._smartComponentExtension.getComponentExtensionSourceFilename(comp), this._smartComponentExtension.compileComponentExtensionSource(comp));
        fsa.generateFile(this._smartComponent.getCompImplHeaderFilename(comp), this._smartComponent.CompImplHeaderFileContent(comp));
        fsa.generateFile(this._smartComponent.getCompImplSourceFilename(comp), this._smartComponent.CompImplSourceFileContent(comp));
        fsa.generateFile(this._smartComponent.getCompHeaderFilename(comp), this._smartComponent.CompHeaderFileContent(comp));
        fsa.generateFile(this._smartComponent.getCompSourceFilename(comp), this._smartComponent.CompSourceFileContent(comp));
        fsa.generateFile(this._smartComponent.getCoreUserHeaderFilename(comp), ExtendedOutputConfigurationProvider.SRC_OUTPUT, this._smartComponent.CoreUserHeaderFileContent(comp));
        fsa.generateFile(this._smartComponent.getCoreUserSourceFilename(comp), ExtendedOutputConfigurationProvider.SRC_OUTPUT, this._smartComponent.CoreUserSourceFileContent(comp));
        fsa.generateFile("CMakeLists.txt", ExtendedOutputConfigurationProvider.SMARTSOFT_OUTPUT, this._componentCMakeGenerator.CMakeListsUserFileContent(comp));
        fsa.generateFile(".gitignore", ExtendedOutputConfigurationProvider.SMARTSOFT_OUTPUT, this.compileDefaultGitignore(comp));
        fsa.generateFile("ComponentProject.cmake", this._componentCMakeGenerator.generateCmakeProjectFile(comp));
        String _name_2 = comp.getName();
        String _plus_2 = (_name_2 + "Dependencies.cmake.in");
        fsa.generateFile(_plus_2, this._componentCMakeGenerator.generateCmakeDependenciesFile(comp));
        fsa.generateFile(this._componentCMakeGenerator.getCMakeMixedPortIncludesFilename(), this._componentCMakeGenerator.generateCMakeMixedPortIncludes(comp));
        fsa.generateFile(this._componentCMakeGenerator.getCMakeMixedPortTargetConfigFilename(), this._componentCMakeGenerator.generateCMakeMixedPortTargetConfigs(comp));
        fsa.generateFile("CompHandler.hh", ExtendedOutputConfigurationProvider.SRC_OUTPUT, this._smartComponent.CompHandlerHeaderFileContent(comp));
        fsa.generateFile("CompHandler.cc", ExtendedOutputConfigurationProvider.SRC_OUTPUT, this._smartComponent.CompHandlerSourceFileContent(comp));
        final Consumer<Activity> _function = (Activity it) -> {
          this._smartTask.CreateSmartTask(it, fsa);
        };
        ComponentDefinitionModelUtility.getActivities(comp).forEach(_function);
        this._smartInputHandler.CreateSmartInputHandlers(comp, fsa);
        this._smartQueryHandler.CreateQueryServerHandlers(comp, fsa);
        this._smartEventHandler.CreateEventTestHandlers(comp, fsa);
        this._smartHandlerState.CreateStateChangeHandler(comp, fsa);
        fsa.generateFile("predeploy.sh", ExtendedOutputConfigurationProvider.SRC_OUTPUT, this.compilePredeployScript(comp));
        fsa.generateFile("startstop-hooks.sh", ExtendedOutputConfigurationProvider.SRC_OUTPUT, this.compileStartStopHooks(comp));
        Iterable<ComponentSubNode> _filter_2 = Iterables.<ComponentSubNode>filter(comp.getElements(), ComponentSubNode.class);
        for (final ComponentSubNode node : _filter_2) {
          fsa.generateFile(this._interactionObserver.getNodeObserverInterfaceHeaderFileName(node), this._interactionObserver.compileNodeObserverInterface(node));
        }
      }
    }
  }
  
  public CharSequence compileDefaultGitignore(final ComponentDefinition comp) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("build/");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compileToolchainVersionFile(final ComponentDefinition comp) {
    StringConcatenation _builder = new StringConcatenation();
    String _toolchainVersionFileString = this._copyrightHelpers.getToolchainVersionFileString();
    _builder.append(_toolchainVersionFileString);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence compilePredeployScript(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#!/bin/bash");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# Use this variable to name files that are to be deployed to the data");
    _builder.newLine();
    _builder.append("# instance directory of");
    _builder.newLine();
    _builder.append("# the component (<COMPONENT INSTANCE NAME>_data/) on the target host.");
    _builder.newLine();
    _builder.append("#");
    _builder.newLine();
    _builder.append("# Files can be relative to component project directory or absolute.");
    _builder.newLine();
    _builder.append("# Add one file or directory per line.");
    _builder.newLine();
    _builder.append("#");
    _builder.newLine();
    _builder.append("# Examples:");
    _builder.newLine();
    _builder.append("#");
    _builder.newLine();
    _builder.append("# DEPLOY_LIBRARIES=\"../bin/libMyLibrary.so\"");
    _builder.newLine();
    _builder.append("#");
    _builder.newLine();
    _builder.append("# DEPLOY_COMPONENT_FILES=\"");
    _builder.newLine();
    _builder.append("# $SMART_ROOT_ACE/myFILE");
    _builder.newLine();
    _builder.append("# $SMART_ROOT_ACE/myFILE2");
    _builder.newLine();
    _builder.append("# \"");
    _builder.newLine();
    _builder.newLine();
    _builder.append("DEPLOY_LIBRARIES=\"\"");
    _builder.newLine();
    _builder.append("DEPLOY_COMPONENT_FILES=\"\"");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compileStartStopHooks(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#!/bin/bash");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# This script provides methods to call custom commands pre/post of starting/stoping the component during launch on the device. ");
    _builder.newLine();
    _builder.append("# This script is being executed on the target device where the component is running. ");
    _builder.newLine();
    _builder.append("# For example the script can be used to start and stop the morse simulator automatically.");
    _builder.newLine();
    _builder.newLine();
    _builder.append("case \"$1\" in");
    _builder.newLine();
    _builder.newLine();
    _builder.append("pre-start)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("echo \"Triggering pre-start hooks FROM COMPONENT ");
    String _name = component.getName();
    _builder.append(_name, "\t");
    _builder.append(" ...\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("# Insert commands you want to call prior to starting the components");
    _builder.newLine();
    _builder.append(";;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("post-start)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("echo \"Triggering post-start hooks FROM COMPONENT ");
    String _name_1 = component.getName();
    _builder.append(_name_1, "\t");
    _builder.append(" ...\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("# Insert commands you want to call after all components were started");
    _builder.newLine();
    _builder.append(";;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("pre-stop)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("echo \"Triggering pre-stop hooks FROM COMPONENT ");
    String _name_2 = component.getName();
    _builder.append(_name_2, "\t");
    _builder.append(" ...\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("# Insert commands you want to call before stopping all components");
    _builder.newLine();
    _builder.append(";;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("post-stop)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("echo \"Triggering post-stop hooks FROM COMPONENT ");
    String _name_3 = component.getName();
    _builder.append(_name_3, "\t");
    _builder.append(" ...\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("# Insert commands you want to call after all components were stopped");
    _builder.newLine();
    _builder.append(";;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("*)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("echo \"ERROR in $0: no such hook \'$1\'. Usage: $0 pre-start|post-start|pre-stop|post-stop\"");
    _builder.newLine();
    _builder.append(";;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("esac");
    _builder.newLine();
    return _builder;
  }
}
