/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Matthias Lutz, Alex Lotz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtext.behavior.skillRealization.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.behavior.skillRealization.CoordinationInterfaceInstance;
import org.eclipse.smartmdsd.ecore.behavior.skillRealization.CoordinationModuleRealization;
import org.eclipse.smartmdsd.ecore.behavior.skillRealization.SkillRealization;
import org.eclipse.smartmdsd.ecore.behavior.skillRealization.SkillRealizationModel;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class SkillRealizationFormatter extends AbstractFormatter2 {
  protected void _format(final SkillRealizationModel skillRealizationModel, @Extension final IFormattableDocument document) {
    EList<CoordinationModuleRealization> _modules = skillRealizationModel.getModules();
    for (final CoordinationModuleRealization coordinationModuleRealization : _modules) {
      document.<CoordinationModuleRealization>format(coordinationModuleRealization);
    }
  }
  
  protected void _format(final CoordinationModuleRealization coordinationModuleRealization, @Extension final IFormattableDocument document) {
    EList<CoordinationInterfaceInstance> _coordInterfaceInsts = coordinationModuleRealization.getCoordInterfaceInsts();
    for (final CoordinationInterfaceInstance coordinationInterfaceInstance : _coordInterfaceInsts) {
      document.<CoordinationInterfaceInstance>format(coordinationInterfaceInstance);
    }
    EList<SkillRealization> _skills = coordinationModuleRealization.getSkills();
    for (final SkillRealization skillRealization : _skills) {
      document.<SkillRealization>format(skillRealization);
    }
  }
  
  public void format(final Object coordinationModuleRealization, final IFormattableDocument document) {
    if (coordinationModuleRealization instanceof XtextResource) {
      _format((XtextResource)coordinationModuleRealization, document);
      return;
    } else if (coordinationModuleRealization instanceof CoordinationModuleRealization) {
      _format((CoordinationModuleRealization)coordinationModuleRealization, document);
      return;
    } else if (coordinationModuleRealization instanceof SkillRealizationModel) {
      _format((SkillRealizationModel)coordinationModuleRealization, document);
      return;
    } else if (coordinationModuleRealization instanceof EObject) {
      _format((EObject)coordinationModuleRealization, document);
      return;
    } else if (coordinationModuleRealization == null) {
      _format((Void)null, document);
      return;
    } else if (coordinationModuleRealization != null) {
      _format(coordinationModuleRealization, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(coordinationModuleRealization, document).toString());
    }
  }
}
