/********************************************************************************
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 ********************************************************************************/
package org.eclipse.smartmdsd.xtext.component.componentParameter.validation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.smartmdsd.xtext.service.parameterDefinition.validation.ParameterDefinitionValidator;
import org.eclipse.xtext.validation.ComposedChecks;
import org.eclipse.xtext.validation.NamesAreUniqueValidator;

@ComposedChecks(validators = {NamesAreUniqueValidator.class})
public abstract class AbstractComponentParameterValidator extends ParameterDefinitionValidator {
	
	@Override
	protected List<EPackage> getEPackages() {
		List<EPackage> result = new ArrayList<EPackage>(super.getEPackages());
		result.add(EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/smartmdsd/component/componentParameter"));
		result.add(EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/smartmdsd/service/parameterDefinition"));
		result.add(EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/smartmdsd/base/basicAttributes"));
		result.add(EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/smartmdsd/base/documentation"));
		return result;
	}
}
