/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.system.deployment.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.deployment.ComponentArtefact;
import org.eclipse.smartmdsd.ecore.system.deployment.DeploymentModel;
import org.eclipse.smartmdsd.ecore.system.deployment.DeploymentPackage;
import org.eclipse.smartmdsd.ecore.system.deployment.NamingService;
import org.eclipse.smartmdsd.ecore.system.deployment.NetworkInterfaceSelection;
import org.eclipse.smartmdsd.ecore.system.deployment.TargetPlatformReference;
import org.eclipse.smartmdsd.ecore.system.deployment.UploadDirectory;
import org.eclipse.smartmdsd.xtext.system.deployment.validation.AbstractDeploymentValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class DeploymentValidator
extends AbstractDeploymentValidator {
    protected static final String DEPLOYMENT_ISSUE_PREFIX = "org.xtext.system.deployment.";
    public static final String MULTIPLE_NAMING_SERVICES = "org.xtext.system.deployment.MultipleNamingServices";
    public static final String MISSING_NETWORK_INTERFACE = "org.xtext.system.deployment.MissingNetworkInterface";
    public static final String MISSING_UPLOAD_DIRECTORY = "org.xtext.system.deployment.MissingUploadDirectory";
    public static final String NO_TARGET_PLATFORMS_DEFINED = "org.xtext.system.deployment.NoTargetPlatformsDefined";
    public static final String MISSING_COMPONENT_ARTEFACT = "org.xtext.system.deployment.MissingComponentArtefact";

    @Check
    public void checkSingleNamingService(NamingService ns) {
        EObject parent = ns.eContainer();
        if (parent instanceof DeploymentModel) {
            boolean _greaterThan;
            int _size = IterableExtensions.size((Iterable)Iterables.filter((Iterable)((DeploymentModel)parent).getElements(), NamingService.class));
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                this.error("Multiple NamingService-elements found, but (at most) one is allowed.", null, MULTIPLE_NAMING_SERVICES, new String[0]);
            }
        }
    }

    @Check
    public void checkMissingElements(TargetPlatformReference ref) {
        UploadDirectory _directory;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        NetworkInterfaceSelection _host = ref.getHost();
        boolean bl = _tripleEquals = _host == null;
        if (_tripleEquals) {
            this.warning("Missing NetworkInterfaceInstance.", null, MISSING_NETWORK_INTERFACE, new String[0]);
        }
        boolean bl2 = _tripleEquals_1 = (_directory = ref.getDirectory()) == null;
        if (_tripleEquals_1) {
            this.warning("Missing UploadDirectory.", null, MISSING_UPLOAD_DIRECTORY, new String[0]);
        }
    }

    @Check
    public void hasTargetPlatforms(DeploymentModel model) {
        boolean _not;
        Functions.Function1 _function = it -> it instanceof TargetPlatformReference;
        boolean _exists = IterableExtensions.exists((Iterable)model.getElements(), (Functions.Function1)_function);
        boolean bl = _not = !_exists;
        if (_not) {
            this.warning("At least one TargetPlatformReference has to be defined.", (EStructuralFeature)DeploymentPackage.Literals.DEPLOYMENT_MODEL__NAME, NO_TARGET_PLATFORMS_DEFINED, new String[0]);
        }
    }

    @Check
    public void allComponentArtefactsAvailable(DeploymentModel model) {
        EList _components = model.getComponentArch().getComponents();
        for (ComponentInstance component : _components) {
            boolean _not;
            Functions.Function1 _function = it -> {
                ComponentInstance _component = it.getComponent();
                return Objects.equal((Object)_component, (Object)component);
            };
            boolean _exists = IterableExtensions.exists((Iterable)Iterables.filter((Iterable)model.getElements(), ComponentArtefact.class), (Functions.Function1)_function);
            boolean bl = _not = !_exists;
            if (!_not) continue;
            String _name = component.getName();
            String _plus = "ComponentInstance " + _name;
            String _plus_1 = String.valueOf(_plus) + " is not used in the deployment model";
            this.warning(_plus_1, (EStructuralFeature)DeploymentPackage.Literals.DEPLOYMENT_MODEL__NAME, MISSING_COMPONENT_ARTEFACT, new String[]{component.getName()});
        }
    }
}

