/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.linux;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenDebianTerminalCommand
extends AbstractHandler {
    public IResource getSelectedResource(IWorkbenchWindow window) {
        ISelection selection = window.getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof IResource) {
                return (IResource)firstElement;
            }
            if (firstElement instanceof IProjectNature) {
                IProjectNature projNature = (IProjectNature)firstElement;
                return projNature.getProject();
            }
        }
        return null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        final IResource currentResource = this.getSelectedResource(window);
        if (currentResource != null) {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            final ILaunchConfigurationType terminalLauncher = launchManager.getLaunchConfigurationType("org.eclipse.smartmdsd.ui.debianTerminalLauncher");
            final IProject project = currentResource.getProject();
            WorkspaceJob openTerminalJob = new WorkspaceJob("Open Terminal Window"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    ILaunchConfigurationWorkingCopy terminalLauncherConfiguration = terminalLauncher.newInstance((IContainer)project, project.getName());
                    terminalLauncherConfiguration.setAttribute("org.eclipse.smartmdsd.ui.debianTerminalLauncher.projectName", project.getName());
                    String workingDir = currentResource.getProjectRelativePath().toString();
                    terminalLauncherConfiguration.setAttribute("org.eclipse.smartmdsd.ui.debianTerminalLauncher.rootWorkingDir", workingDir);
                    terminalLauncherConfiguration.launch("run", monitor);
                    return Status.OK_STATUS;
                }
            };
            openTerminalJob.schedule();
        }
        return null;
    }
}

