/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.parameterDefinition;

import com.google.inject.Binder;
import com.google.inject.name.Names;
import org.eclipse.smartmdsd.xtext.service.parameterDefinition.AbstractParameterDefinitionRuntimeModule;
import org.eclipse.smartmdsd.xtext.service.parameterDefinition.scoping.ParameterDefinitionImportedNamespaceAwareLocalScopeProvider;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;

/**
 * Use this class to register components to be used at runtime / without the Equinox extension registry.
 */
@SuppressWarnings("all")
public class ParameterDefinitionRuntimeModule extends AbstractParameterDefinitionRuntimeModule {
  @Override
  public void configureIScopeProviderDelegate(final Binder binder) {
    binder.<IScopeProvider>bind(IScopeProvider.class).annotatedWith(Names.named(AbstractDeclarativeScopeProvider.NAMED_DELEGATE)).to(ParameterDefinitionImportedNamespaceAwareLocalScopeProvider.class);
  }
}
