/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.component.componentDefinition;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AnswerPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNode;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNodeObserver;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputHandler;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPortLink;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.OutputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.RequestHandler;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.RequestPort;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommunicationServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefinitionModelUtility;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class ComponentDefinitionModelUtility extends ServiceDefinitionModelUtility {
  public static LinkedHashSet<Activity> getActivityObservationHierarchy(final Activity activity) {
    return ComponentDefinitionModelUtility.iterateObservers(activity, CollectionLiterals.<Activity>newLinkedHashSet());
  }
  
  private static LinkedHashSet<Activity> iterateObservers(final Activity current, final LinkedHashSet<Activity> visited) {
    Iterable<ComponentSubNodeObserver> _observers = ComponentDefinitionModelUtility.getObservers(current);
    for (final ComponentSubNodeObserver observer : _observers) {
      {
        final ComponentSubNode subject = observer.getSubject();
        if ((subject instanceof Activity)) {
          boolean _contains = visited.contains(subject);
          boolean _not = (!_contains);
          if (_not) {
            visited.add(((Activity)subject));
            visited.addAll(ComponentDefinitionModelUtility.iterateObservers(((Activity)subject), visited));
          }
        } else {
          if ((subject instanceof RequestHandler)) {
          }
        }
      }
    }
    return visited;
  }
  
  public static Iterable<ComponentSubNodeObserver> getObservers(final ComponentSubNode node) {
    return Iterables.<ComponentSubNodeObserver>filter(node.getLinks(), ComponentSubNodeObserver.class);
  }
  
  public static Iterable<ComponentSubNode> getSubNodes(final ComponentDefinition component) {
    return Iterables.<ComponentSubNode>filter(component.getElements(), ComponentSubNode.class);
  }
  
  public static CommunicationServiceDefinition getService(final ComponentPort port) {
    boolean _matched = false;
    if (port instanceof InputPort) {
      _matched=true;
      return ((InputPort)port).getService();
    }
    if (!_matched) {
      if (port instanceof AnswerPort) {
        _matched=true;
        return ((AnswerPort)port).getService();
      }
    }
    if (!_matched) {
      if (port instanceof OutputPort) {
        _matched=true;
        return ((OutputPort)port).getService();
      }
    }
    if (!_matched) {
      if (port instanceof RequestPort) {
        _matched=true;
        return ((RequestPort)port).getService();
      }
    }
    return null;
  }
  
  public static Iterable<InputPortLink> getInputLinks(final ComponentSubNode node) {
    return Iterables.<InputPortLink>filter(node.getLinks(), InputPortLink.class);
  }
  
  public static Boolean isOptional(final ComponentPort port) {
    if ((port instanceof InputPort)) {
      final EObject parent = ((InputPort)port).eContainer();
      if ((parent instanceof ComponentDefinition)) {
        final Function1<Activity, Boolean> _function = (Activity it) -> {
          final Function1<InputPortLink, Boolean> _function_1 = (InputPortLink it_1) -> {
            return Boolean.valueOf((Objects.equal(it_1.getInputPort(), port) && (it_1.isOptional() == false)));
          };
          return Boolean.valueOf(IterableExtensions.<InputPortLink>exists(ComponentDefinitionModelUtility.getInputLinks(it), _function_1));
        };
        boolean _exists = IterableExtensions.<Activity>exists(ComponentDefinitionModelUtility.getActivities(((ComponentDefinition)parent)), _function);
        boolean _not = (!_exists);
        if (_not) {
          final Function1<InputHandler, Boolean> _function_1 = (InputHandler it) -> {
            final Function1<InputPortLink, Boolean> _function_2 = (InputPortLink it_1) -> {
              return Boolean.valueOf((Objects.equal(it_1.getInputPort(), port) && (it_1.isOptional() == false)));
            };
            return Boolean.valueOf(IterableExtensions.<InputPortLink>exists(ComponentDefinitionModelUtility.getInputLinks(it), _function_2));
          };
          boolean _exists_1 = IterableExtensions.<InputHandler>exists(ComponentDefinitionModelUtility.getInputHandlers(((ComponentDefinition)parent)), _function_1);
          boolean _not_1 = (!_exists_1);
          if (_not_1) {
            return Boolean.valueOf(true);
          }
        }
      }
    }
    return Boolean.valueOf(false);
  }
  
  public static Collection<CommunicationObject> getAllCommObjects(final ComponentPort port) {
    return ServiceDefinitionModelUtility.getAllCommObjects(ComponentDefinitionModelUtility.getService(port));
  }
  
  public static Collection<CommunicationObject> getAllCommObjects(final RequestHandler handler) {
    return ServiceDefinitionModelUtility.getAllCommObjects(handler.getAnswerPort().getService());
  }
  
  public static Collection<CommunicationObject> getAllCommObjects(final Activity activity) {
    final HashSet<CommunicationObject> objects = new HashSet<CommunicationObject>();
    final Consumer<InputPortLink> _function = (InputPortLink it) -> {
      objects.addAll(ComponentDefinitionModelUtility.getAllCommObjects(it.getInputPort()));
    };
    ComponentDefinitionModelUtility.getInputLinks(activity).forEach(_function);
    return objects;
  }
  
  public static Collection<CommunicationObject> getAllCommObjects(final ComponentDefinition component) {
    final HashSet<CommunicationObject> objects = new HashSet<CommunicationObject>();
    final Consumer<ComponentPort> _function = (ComponentPort it) -> {
      objects.addAll(ComponentDefinitionModelUtility.getAllCommObjects(it));
    };
    Iterables.<ComponentPort>filter(component.getElements(), ComponentPort.class).forEach(_function);
    return objects;
  }
  
  public static Iterable<Activity> getActivities(final ComponentDefinition component) {
    return Iterables.<Activity>filter(component.getElements(), Activity.class);
  }
  
  public static Iterable<InputHandler> getInputHandlers(final ComponentDefinition component) {
    return Iterables.<InputHandler>filter(component.getElements(), InputHandler.class);
  }
  
  public static Iterable<RequestHandler> getRequestHandlers(final ComponentDefinition component) {
    return Iterables.<RequestHandler>filter(component.getElements(), RequestHandler.class);
  }
  
  public static Iterable<InputPort> getInputPorts(final ComponentDefinition component) {
    return Iterables.<InputPort>filter(component.getElements(), InputPort.class);
  }
  
  public static Iterable<AnswerPort> getAnswerPorts(final ComponentDefinition component) {
    return Iterables.<AnswerPort>filter(component.getElements(), AnswerPort.class);
  }
  
  public static Iterable<OutputPort> getOutputPorts(final ComponentDefinition component) {
    return Iterables.<OutputPort>filter(component.getElements(), OutputPort.class);
  }
  
  public static Iterable<RequestPort> getRequestPorts(final ComponentDefinition component) {
    return Iterables.<RequestPort>filter(component.getElements(), RequestPort.class);
  }
  
  public static Iterable<ComponentPort> getPorts(final ComponentDefinition component) {
    return Iterables.<ComponentPort>filter(component.getElements(), ComponentPort.class);
  }
}
