/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component;

import com.google.inject.Inject;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNode;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.ComponentGenHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class InteractionObserver {
  @Inject
  @Extension
  private CopyrightHelpers _copyrightHelpers;
  
  @Inject
  @Extension
  private ComponentGenHelpers _componentGenHelpers;
  
  public String getNodeObserverInterfaceClassName(final ComponentSubNode node) {
    String _nameClass = this._componentGenHelpers.nameClass(node);
    return (_nameClass + "ObserverInterface");
  }
  
  public String getNodeObserverInterfaceHeaderFileName(final ComponentSubNode node) {
    String _nodeObserverInterfaceClassName = this.getNodeObserverInterfaceClassName(node);
    return (_nodeObserverInterfaceClassName + ".hh");
  }
  
  public CharSequence compileNodeObserverInterface(final ComponentSubNode node) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef _");
    String _upperCase = node.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_OBSERVER_INTERFACE_HH");
    _builder.newLineIfNotEmpty();
    _builder.append("#define _");
    String _upperCase_1 = node.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_OBSERVER_INTERFACE_HH");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// forward declaration");
    _builder.newLine();
    _builder.append("class ");
    String _nameClass = this._componentGenHelpers.nameClass(node);
    _builder.append(_nameClass);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("class ");
    String _nodeObserverInterfaceClassName = this.getNodeObserverInterfaceClassName(node);
    _builder.append(_nodeObserverInterfaceClassName);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual ~");
    String _nodeObserverInterfaceClassName_1 = this.getNodeObserverInterfaceClassName(node);
    _builder.append(_nodeObserverInterfaceClassName_1, "\t");
    _builder.append("() {  }");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void on_update_from(const ");
    String _nameClass_1 = this._componentGenHelpers.nameClass(node);
    _builder.append(_nameClass_1, "\t");
    _builder.append(" *subject) = 0;");
    _builder.newLineIfNotEmpty();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compileNodeSubjectHeader(final ComponentSubNode node) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Implementation of the Subject part of an InteractionObserver");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("private:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::mutex interaction_observers_mutex;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::list<");
    String _nodeObserverInterfaceClassName = this.getNodeObserverInterfaceClassName(node);
    _builder.append(_nodeObserverInterfaceClassName, "\t");
    _builder.append("*> interaction_observers;");
    _builder.newLineIfNotEmpty();
    _builder.append("protected:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void notify_all_interaction_observers();");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void attach_interaction_observer(");
    String _nodeObserverInterfaceClassName_1 = this.getNodeObserverInterfaceClassName(node);
    _builder.append(_nodeObserverInterfaceClassName_1, "\t");
    _builder.append(" *observer);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("void detach_interaction_observer(");
    String _nodeObserverInterfaceClassName_2 = this.getNodeObserverInterfaceClassName(node);
    _builder.append(_nodeObserverInterfaceClassName_2, "\t");
    _builder.append(" *observer);");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence compileNodeSubjectSource(final ComponentSubNode node) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("void ");
    String _nameClass = this._componentGenHelpers.nameClass(node);
    _builder.append(_nameClass);
    _builder.append("Core::notify_all_interaction_observers() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("std::unique_lock<std::mutex> lock(interaction_observers_mutex);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// try dynamically down-casting this class to the derived class ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// (we can do it safely here as we exactly know the derived class)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if(const ");
    String _nameClass_1 = this._componentGenHelpers.nameClass(node);
    _builder.append(_nameClass_1, "\t");
    _builder.append("* ");
    String _nameInstance = this._componentGenHelpers.nameInstance(node);
    _builder.append(_nameInstance, "\t");
    _builder.append(" = dynamic_cast<const ");
    String _nameClass_2 = this._componentGenHelpers.nameClass(node);
    _builder.append(_nameClass_2, "\t");
    _builder.append("*>(this)) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("for(auto it=interaction_observers.begin(); it!=interaction_observers.end(); it++) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("(*it)->on_update_from(");
    String _nameInstance_1 = this._componentGenHelpers.nameInstance(node);
    _builder.append(_nameInstance_1, "\t\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ");
    String _nameClass_3 = this._componentGenHelpers.nameClass(node);
    _builder.append(_nameClass_3);
    _builder.append("Core::attach_interaction_observer(");
    String _nodeObserverInterfaceClassName = this.getNodeObserverInterfaceClassName(node);
    _builder.append(_nodeObserverInterfaceClassName);
    _builder.append(" *observer) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("std::unique_lock<std::mutex> lock(interaction_observers_mutex);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("interaction_observers.push_back(observer);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ");
    String _nameClass_4 = this._componentGenHelpers.nameClass(node);
    _builder.append(_nameClass_4);
    _builder.append("Core::detach_interaction_observer(");
    String _nodeObserverInterfaceClassName_1 = this.getNodeObserverInterfaceClassName(node);
    _builder.append(_nodeObserverInterfaceClassName_1);
    _builder.append(" *observer) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("std::unique_lock<std::mutex> lock(interaction_observers_mutex);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("interaction_observers.remove(observer);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
