/********************************************************************************
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 ********************************************************************************/
package org.eclipse.smartmdsd.xtext.system.systemDatasheet.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.DatasheetProperty;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.GenericDatasheetPackage;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElement;
import org.eclipse.smartmdsd.ecore.system.systemDatasheet.SystemDatasheet;
import org.eclipse.smartmdsd.ecore.system.systemDatasheet.SystemDatasheetPackage;
import org.eclipse.smartmdsd.xtext.base.genericDatasheet.serializer.GenericDatasheetSemanticSequencer;
import org.eclipse.smartmdsd.xtext.system.systemDatasheet.services.SystemDatasheetGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;

@SuppressWarnings("all")
public class SystemDatasheetSemanticSequencer extends GenericDatasheetSemanticSequencer {

	@Inject
	private SystemDatasheetGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == GenericDatasheetPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case GenericDatasheetPackage.DATASHEET_PROPERTY:
				sequence_DatasheetProperty(context, (DatasheetProperty) semanticObject); 
				return; 
			case GenericDatasheetPackage.MANDATORY_DATASHEET_ELEMENT:
				sequence_MandatoryDatasheetElement(context, (MandatoryDatasheetElement) semanticObject); 
				return; 
			}
		else if (epackage == SystemDatasheetPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case SystemDatasheetPackage.SYSTEM_DATASHEET:
				sequence_GenericDatasheetModel_SystemDatasheet(context, (SystemDatasheet) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     SystemDatasheet returns SystemDatasheet
	 *
	 * Constraint:
	 *     (name=ID elements+=AbstractDatasheetElement*)
	 */
	protected void sequence_GenericDatasheetModel_SystemDatasheet(ISerializationContext context, SystemDatasheet semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
}
