/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.factories;

import com.google.inject.Injector;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.resource.XtextLiveScopeResourceSetProvider;

public class XtextResourceFactory {
    private final IProject project;
    private final IFolder modelFolder;

    public XtextResourceFactory(IProject project, IFolder modelFolder) {
        this.project = project;
        this.modelFolder = modelFolder;
    }

    public final IProject getProject() {
        return this.project;
    }

    public final IFolder getModelFolder() {
        return this.modelFolder;
    }

    private String getModelFileExtension(Injector injector) {
        return ((FileExtensionProvider)injector.getInstance(FileExtensionProvider.class)).getPrimaryFileExtension();
    }

    public Resource loadEMFResource(Injector injector) {
        if (this.modelFolder.exists()) {
            String modelFileExtrnsion = this.getModelFileExtension(injector);
            IFile modelFile = this.modelFolder.getFile(String.valueOf(this.project.getName()) + "." + modelFileExtrnsion);
            if (modelFile.exists()) {
                IResourceSetProvider resourceSetProvider = (IResourceSetProvider)injector.getInstance(IResourceSetProvider.class);
                ResourceSet resourceSet = resourceSetProvider.get(this.project);
                URI uri = URI.createURI((String)("platform:/resource/" + this.project.getName() + "/" + modelFile.getProjectRelativePath()));
                boolean loadOnDemand = true;
                return resourceSet.getResource(uri, loadOnDemand);
            }
        }
        return null;
    }

    public Resource createNewXtextResource(Injector injector, List<Resource> relatedResources) {
        if (this.modelFolder.exists()) {
            String modelFileExtrnsion = this.getModelFileExtension(injector);
            XtextLiveScopeResourceSetProvider resourceSetProvider = (XtextLiveScopeResourceSetProvider)injector.getInstance(XtextLiveScopeResourceSetProvider.class);
            ResourceSet resourceSet = resourceSetProvider.get(this.project);
            if (relatedResources != null) {
                for (Resource relatedResource : relatedResources) {
                    resourceSet.getResources().add((Object)relatedResource);
                }
            }
            URI uri = URI.createURI((String)("platform:/resource/" + this.project.getName() + "/" + this.modelFolder.getProjectRelativePath() + "/" + this.project.getName() + "." + modelFileExtrnsion));
            return resourceSet.createResource(uri);
        }
        return null;
    }

    public void saveEMFModelInResource(EObject emfModel, Resource newResource) {
        newResource.getContents().add((Object)emfModel);
        try {
            SaveOptions saveOptions = SaveOptions.newBuilder().format().getOptions();
            newResource.save(saveOptions.toOptionsMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

