/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.component.componentParameter;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.component.componentParameter.AbstractParameterInstance;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameterBase;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ExtendedParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.InternalParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ParameterInstance;
import org.eclipse.smartmdsd.ecore.component.componentParameter.TriggerInstance;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterDefinition;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.TriggerDefinition;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class ComponentParameterModelUtility extends ParameterDefinitionModelUtility {
  public EList<AttributeDefinition> getReferencedAttributes(final AbstractParameterInstance instance) {
    if ((instance instanceof ParameterInstance)) {
      ParameterDefinition _parameterDef = ((ParameterInstance)instance).getParameterDef();
      EList<AttributeDefinition> _attributes = null;
      if (_parameterDef!=null) {
        _attributes=_parameterDef.getAttributes();
      }
      return _attributes;
    } else {
      if ((instance instanceof TriggerInstance)) {
        TriggerDefinition _triggerDef = ((TriggerInstance)instance).getTriggerDef();
        EList<AttributeDefinition> _attributes_1 = null;
        if (_triggerDef!=null) {
          _attributes_1=_triggerDef.getAttributes();
        }
        return _attributes_1;
      }
    }
    return null;
  }
  
  public Iterable<AttributeDefinition> getAttributeDefs(final ComponentParameterBase param) {
    List<AttributeDefinition> _switchResult = null;
    boolean _matched = false;
    if (param instanceof InternalParameter) {
      _matched=true;
      _switchResult = ((InternalParameter)param).getAttributes();
    }
    if (!_matched) {
      if (param instanceof ExtendedParameter) {
        _matched=true;
        _switchResult = ((ExtendedParameter)param).getAttributes();
      }
    }
    if (!_matched) {
      if (param instanceof ParameterInstance) {
        _matched=true;
        final Function1<AttributeRefinement, AttributeDefinition> _function = (AttributeRefinement it) -> {
          return it.getAttribute();
        };
        _switchResult = ListExtensions.<AttributeRefinement, AttributeDefinition>map(((ParameterInstance)param).getAttributes(), _function);
      }
    }
    return _switchResult;
  }
}
