/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Matthias Lutz, Alex Lotz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.behavior.generator.domainModels;

import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.DomainModelsGeneratorExtension;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class CoordinationDomainModelsExtension implements DomainModelsGeneratorExtension {
  @Override
  public String getExtensionName(final CommObjectsRepository repo) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("coordination interfaces extensions");
    return _builder.toString();
  }
  
  @Override
  public CharSequence getCMakeExtension(final CommObjectsRepository repo) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("GET_FILENAME_COMPONENT(Coordination_DIR \"${PROJECT_SOURCE_DIR}/../coordination\" REALPATH)");
    _builder.newLine();
    _builder.append("IF(EXISTS ${Coordination_DIR})");
    _builder.newLine();
    _builder.append("MESSAGE(\"-- Include CoordinationInterfaces\")");
    _builder.newLine();
    _builder.append("INCLUDE(\"${Coordination_DIR}/src-gen/coordinationInterfaces.cmake\")");
    _builder.newLine();
    _builder.append("ENDIF(EXISTS ${Coordination_DIR})");
    _builder.newLine();
    return _builder;
  }
}
