/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AbstractComponentElement;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AnswerPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNodeObserver;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.DerivedComponentElement;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.NamedComponentElement;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.OutputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.RequestPort;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParametersRef;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.ActivationConstraints;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.PlainOpcUaPort;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.SupportedMiddleware;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.CommunicationPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.EventPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.ForkingPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.PushPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.QueryPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.SendPattern;
import org.eclipse.smartmdsd.ecore.service.roboticMiddleware.ACE_SmartSoft;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommunicationServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ForkingServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.JoiningServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.OneWayCommunicationService;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.CommObjectGenHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.ActivityGeneratorExtension;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.ComponentGeneratorExtension;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartTimerDummy;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class ComponentGenHelpers {
  @Inject
  private CommObjectGenHelpers comm;
  
  public String nameClass(final ComponentDefinition c) {
    return StringExtensions.toFirstUpper(c.getName());
  }
  
  public String nameClass(final AbstractComponentElement elem) {
    String _switchResult = null;
    boolean _matched = false;
    if (elem instanceof NamedComponentElement) {
      _matched=true;
      _switchResult = StringExtensions.toFirstUpper(((NamedComponentElement)elem).getName());
    }
    if (!_matched) {
      if (elem instanceof DerivedComponentElement) {
        _matched=true;
        _switchResult = StringExtensions.toFirstUpper(((DerivedComponentElement)elem).getName());
      }
    }
    if (!_matched) {
      if (elem instanceof PlainOpcUaPort) {
        _matched=true;
        _switchResult = StringExtensions.toFirstUpper(((PlainOpcUaPort)elem).getName());
      }
    }
    return _switchResult;
  }
  
  public String nameClass(final SmartTimerDummy p) {
    return StringExtensions.toFirstUpper(p.getName());
  }
  
  public String getNameClass(final ComponentSubNodeObserver obs) {
    return StringExtensions.toFirstUpper(obs.getSubject().getName());
  }
  
  public String nameInstance(final ComponentDefinition c) {
    return StringExtensions.toFirstLower(c.getName());
  }
  
  public String nameInstance(final AbstractComponentElement elem) {
    String _switchResult = null;
    boolean _matched = false;
    if (elem instanceof NamedComponentElement) {
      _matched=true;
      _switchResult = StringExtensions.toFirstLower(((NamedComponentElement)elem).getName());
    }
    if (!_matched) {
      if (elem instanceof DerivedComponentElement) {
        _matched=true;
        _switchResult = StringExtensions.toFirstLower(((DerivedComponentElement)elem).getName());
      }
    }
    if (!_matched) {
      if (elem instanceof PlainOpcUaPort) {
        _matched=true;
        _switchResult = StringExtensions.toFirstLower(((PlainOpcUaPort)elem).getName());
      }
    }
    return _switchResult;
  }
  
  public String nameInstance(final SmartTimerDummy p) {
    return StringExtensions.toFirstLower(p.getName());
  }
  
  public String nameInstance(final ComponentSubNodeObserver obs) {
    return StringExtensions.toFirstLower(obs.getSubject().getName());
  }
  
  public String nameOriginal(final ComponentDefinition c) {
    return c.getName();
  }
  
  public String nameOriginal(final AbstractComponentElement elem) {
    String _switchResult = null;
    boolean _matched = false;
    if (elem instanceof NamedComponentElement) {
      _matched=true;
      _switchResult = ((NamedComponentElement)elem).getName();
    }
    if (!_matched) {
      if (elem instanceof DerivedComponentElement) {
        _matched=true;
        _switchResult = ((DerivedComponentElement)elem).getName();
      }
    }
    if (!_matched) {
      if (elem instanceof PlainOpcUaPort) {
        _matched=true;
        _switchResult = ((PlainOpcUaPort)elem).getName();
      }
    }
    return _switchResult;
  }
  
  public String nameOriginal(final SmartTimerDummy p) {
    return p.getName();
  }
  
  public String nameOriginal(final ComponentSubNodeObserver obs) {
    return obs.getSubject().getName();
  }
  
  public CommunicationPattern getPattern(final ComponentPort port) {
    final CommunicationServiceDefinition service = ComponentDefinitionModelUtility.getService(port);
    return ComponentDefinitionModelUtility.getPattern(service);
  }
  
  public Double getMinActFreq(final Activity task) {
    int _size = IterableExtensions.size(Iterables.<ActivationConstraints>filter(task.getExtensions(), ActivationConstraints.class));
    boolean _equals = (_size == 0);
    if (_equals) {
      return Double.valueOf(0.0);
    } else {
      return Double.valueOf((((ActivationConstraints[])Conversions.unwrapArray((Iterables.<ActivationConstraints>filter(task.getExtensions(), ActivationConstraints.class)), ActivationConstraints.class))[0]).getMinActFreq());
    }
  }
  
  public Double getMaxActFreq(final Activity task) {
    int _size = IterableExtensions.size(Iterables.<ActivationConstraints>filter(task.getExtensions(), ActivationConstraints.class));
    boolean _equals = (_size == 0);
    if (_equals) {
      return Double.valueOf(0.0);
    } else {
      return Double.valueOf((((ActivationConstraints[])Conversions.unwrapArray((Iterables.<ActivationConstraints>filter(task.getExtensions(), ActivationConstraints.class)), ActivationConstraints.class))[0]).getMaxActFreq());
    }
  }
  
  public Double getUpdateRate(final Activity task) {
    Double _minActFreq = this.getMinActFreq(task);
    boolean _greaterThan = ((_minActFreq).doubleValue() > 0.0);
    if (_greaterThan) {
      return this.getMinActFreq(task);
    } else {
      Double _maxActFreq = this.getMaxActFreq(task);
      boolean _greaterThan_1 = ((_maxActFreq).doubleValue() > 0.0);
      if (_greaterThan_1) {
        return this.getMaxActFreq(task);
      } else {
        return Double.valueOf(1.0);
      }
    }
  }
  
  public Boolean hasParameters(final ComponentDefinition component) {
    int _size = IterableExtensions.size(Iterables.<ComponentParametersRef>filter(component.getElements(), ComponentParametersRef.class));
    return Boolean.valueOf((_size > 0));
  }
  
  public CharSequence getCommObjectCppList(final CommunicationPattern pattern, final Boolean isSource) {
    if ((pattern instanceof PushPattern)) {
      return this.comm.getFullyQualifiedNameCpp(((PushPattern)pattern).getDataType());
    } else {
      if ((pattern instanceof SendPattern)) {
        return this.comm.getFullyQualifiedNameCpp(((SendPattern)pattern).getDataType());
      } else {
        if ((pattern instanceof QueryPattern)) {
          String name = this.comm.getFullyQualifiedNameCpp(((QueryPattern)pattern).getRequestType()).toString();
          String _name = name;
          String _string = this.comm.getFullyQualifiedNameCpp(((QueryPattern)pattern).getAnswerType()).toString();
          String _plus = (", " + _string);
          name = (_name + _plus);
          return name;
        } else {
          if ((pattern instanceof EventPattern)) {
            String name_1 = this.comm.getFullyQualifiedNameCpp(((EventPattern)pattern).getActivationType()).toString();
            String _name_1 = name_1;
            String _string_1 = this.comm.getFullyQualifiedNameCpp(((EventPattern)pattern).getEventType()).toString();
            String _plus_1 = (", " + _string_1);
            name_1 = (_name_1 + _plus_1);
            if ((isSource).booleanValue()) {
              String _name_2 = name_1;
              String _string_2 = this.comm.getFullyQualifiedNameCpp(((EventPattern)pattern).getEventStateType()).toString();
              String _plus_2 = (", " + _string_2);
              name_1 = (_name_2 + _plus_2);
            }
            return name_1;
          }
        }
      }
    }
    return null;
  }
  
  public boolean isEventServer(final AbstractComponentElement element) {
    if ((element instanceof OutputPort)) {
      final CommunicationPattern pattern = this.getPattern(((ComponentPort)element));
      return (pattern instanceof EventPattern);
    }
    return false;
  }
  
  public CharSequence getEventServerStateObject(final AbstractComponentElement element) {
    if ((element instanceof OutputPort)) {
      final CommunicationPattern pattern = this.getPattern(((ComponentPort)element));
      return this.comm.getFullyQualifiedNameCpp(((EventPattern) pattern).getEventStateType());
    }
    return "";
  }
  
  public CharSequence getInputHandlerCommObject(final ComponentPort service) {
    if ((service instanceof InputPort)) {
      final CommunicationPattern pattern = this.getPattern(service);
      if ((pattern instanceof EventPattern)) {
        CharSequence _fullyQualifiedNameCpp = this.comm.getFullyQualifiedNameCpp(((EventPattern)pattern).getEventType());
        String _plus = ("Smart::EventInputType<" + _fullyQualifiedNameCpp);
        return (_plus + ">");
      }
    }
    return this.getCommObjectCppList(service, Boolean.valueOf(false));
  }
  
  public CharSequence getCommObjectCppList(final ComponentPort service, final Boolean isSource) {
    final CommunicationPattern pattern = this.getPattern(service);
    return this.getCommObjectCppList(pattern, isSource);
  }
  
  protected String _getPortDefinition(final OutputPort port) {
    String _xblockexpression = null;
    {
      final CommunicationPattern pattern = this.getPattern(port);
      String _switchResult = null;
      boolean _matched = false;
      if (pattern instanceof PushPattern) {
        _matched=true;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Smart::IPushServerPattern<");
        CharSequence _commObjectCppList = this.getCommObjectCppList(pattern, Boolean.valueOf(true));
        _builder.append(_commObjectCppList);
        _builder.append(">");
        _switchResult = _builder.toString();
      }
      if (!_matched) {
        if (pattern instanceof EventPattern) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("Smart::IEventServerPattern<");
          CharSequence _commObjectCppList = this.getCommObjectCppList(pattern, Boolean.valueOf(true));
          _builder.append(_commObjectCppList);
          _builder.append(">");
          _switchResult = _builder.toString();
        }
      }
      if (!_matched) {
        if (pattern instanceof SendPattern) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("Smart::ISendClientPattern<");
          CharSequence _commObjectCppList = this.getCommObjectCppList(pattern, Boolean.valueOf(true));
          _builder.append(_commObjectCppList);
          _builder.append(">");
          _switchResult = _builder.toString();
        }
      }
      if (!_matched) {
        _switchResult = "";
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
  
  protected String _getPortDefinition(final InputPort port) {
    String _xblockexpression = null;
    {
      final CommunicationPattern pattern = this.getPattern(port);
      String _switchResult = null;
      boolean _matched = false;
      if (pattern instanceof PushPattern) {
        _matched=true;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Smart::IPushClientPattern<");
        CharSequence _commObjectCppList = this.getCommObjectCppList(pattern, Boolean.valueOf(false));
        _builder.append(_commObjectCppList);
        _builder.append(">");
        _switchResult = _builder.toString();
      }
      if (!_matched) {
        if (pattern instanceof EventPattern) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("Smart::IEventClientPattern<");
          CharSequence _commObjectCppList = this.getCommObjectCppList(pattern, Boolean.valueOf(false));
          _builder.append(_commObjectCppList);
          _builder.append(">");
          _switchResult = _builder.toString();
        }
      }
      if (!_matched) {
        if (pattern instanceof SendPattern) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("Smart::ISendServerPattern<");
          CharSequence _commObjectCppList = this.getCommObjectCppList(pattern, Boolean.valueOf(false));
          _builder.append(_commObjectCppList);
          _builder.append(">");
          _switchResult = _builder.toString();
        }
      }
      if (!_matched) {
        _switchResult = "";
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
  
  protected String _getPortDefinition(final RequestPort port) {
    String _xblockexpression = null;
    {
      final CommunicationPattern pattern = this.getPattern(port);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Smart::IQueryClientPattern<");
      CharSequence _commObjectCppList = this.getCommObjectCppList(pattern, Boolean.valueOf(true));
      _builder.append(_commObjectCppList);
      _builder.append(">");
      _xblockexpression = _builder.toString();
    }
    return _xblockexpression;
  }
  
  protected String _getPortDefinition(final AnswerPort port) {
    String _xblockexpression = null;
    {
      final CommunicationPattern pattern = this.getPattern(port);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Smart::IQueryServerPattern<");
      CharSequence _commObjectCppList = this.getCommObjectCppList(pattern, Boolean.valueOf(false));
      _builder.append(_commObjectCppList);
      _builder.append(">");
      _xblockexpression = _builder.toString();
    }
    return _xblockexpression;
  }
  
  protected String _getPortImplementation(final OutputPort port) {
    String _xblockexpression = null;
    {
      final CommunicationPattern pattern = this.getPattern(port);
      String _switchResult = null;
      boolean _matched = false;
      if (pattern instanceof PushPattern) {
        _matched=true;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("SmartACE::PushServer<");
        CharSequence _commObjectCppList = this.getCommObjectCppList(pattern, Boolean.valueOf(true));
        _builder.append(_commObjectCppList);
        _builder.append(">");
        _switchResult = _builder.toString();
      }
      if (!_matched) {
        if (pattern instanceof EventPattern) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("SmartACE::EventServer<");
          CharSequence _commObjectCppList = this.getCommObjectCppList(pattern, Boolean.valueOf(true));
          _builder.append(_commObjectCppList);
          _builder.append(">");
          _switchResult = _builder.toString();
        }
      }
      if (!_matched) {
        if (pattern instanceof SendPattern) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("SmartACE::SendClient<");
          CharSequence _commObjectCppList = this.getCommObjectCppList(pattern, Boolean.valueOf(true));
          _builder.append(_commObjectCppList);
          _builder.append(">");
          _switchResult = _builder.toString();
        }
      }
      if (!_matched) {
        _switchResult = "";
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
  
  protected String _getPortImplementation(final InputPort port) {
    String _xblockexpression = null;
    {
      final CommunicationPattern pattern = this.getPattern(port);
      String _switchResult = null;
      boolean _matched = false;
      if (pattern instanceof PushPattern) {
        _matched=true;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("SmartACE::PushClient<");
        CharSequence _commObjectCppList = this.getCommObjectCppList(pattern, Boolean.valueOf(false));
        _builder.append(_commObjectCppList);
        _builder.append(">");
        _switchResult = _builder.toString();
      }
      if (!_matched) {
        if (pattern instanceof EventPattern) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("SmartACE::EventClient<");
          CharSequence _commObjectCppList = this.getCommObjectCppList(pattern, Boolean.valueOf(false));
          _builder.append(_commObjectCppList);
          _builder.append(">");
          _switchResult = _builder.toString();
        }
      }
      if (!_matched) {
        if (pattern instanceof SendPattern) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("SmartACE::SendServer<");
          CharSequence _commObjectCppList = this.getCommObjectCppList(pattern, Boolean.valueOf(false));
          _builder.append(_commObjectCppList);
          _builder.append(">");
          _switchResult = _builder.toString();
        }
      }
      if (!_matched) {
        _switchResult = "";
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
  
  protected String _getPortImplementation(final RequestPort port) {
    String _xblockexpression = null;
    {
      final CommunicationPattern pattern = this.getPattern(port);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("SmartACE::QueryClient<");
      CharSequence _commObjectCppList = this.getCommObjectCppList(pattern, Boolean.valueOf(true));
      _builder.append(_commObjectCppList);
      _builder.append(">");
      _xblockexpression = _builder.toString();
    }
    return _xblockexpression;
  }
  
  protected String _getPortImplementation(final AnswerPort port) {
    String _xblockexpression = null;
    {
      final CommunicationPattern pattern = this.getPattern(port);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("SmartACE::QueryServer<");
      CharSequence _commObjectCppList = this.getCommObjectCppList(pattern, Boolean.valueOf(false));
      _builder.append(_commObjectCppList);
      _builder.append(">");
      _xblockexpression = _builder.toString();
    }
    return _xblockexpression;
  }
  
  protected Map<String, CommunicationObject> _getCommunicationObjects(final OutputPort port) {
    final HashMap<String, CommunicationObject> objects = new HashMap<String, CommunicationObject>();
    final CommunicationPattern pattern = this.getPattern(port);
    boolean _matched = false;
    if (pattern instanceof PushPattern) {
      _matched=true;
      objects.put("Data", ((PushPattern)pattern).getDataType());
    }
    if (!_matched) {
      if (pattern instanceof EventPattern) {
        _matched=true;
        objects.put("Activation", ((EventPattern)pattern).getActivationType());
        objects.put("Event", ((EventPattern)pattern).getEventType());
        objects.put("EventState", ((EventPattern)pattern).getEventStateType());
      }
    }
    if (!_matched) {
      if (pattern instanceof SendPattern) {
        _matched=true;
        objects.put("Data", ((SendPattern)pattern).getDataType());
      }
    }
    return objects;
  }
  
  protected Map<String, CommunicationObject> _getCommunicationObjects(final InputPort port) {
    final HashMap<String, CommunicationObject> objects = new HashMap<String, CommunicationObject>();
    final CommunicationPattern pattern = this.getPattern(port);
    boolean _matched = false;
    if (pattern instanceof PushPattern) {
      _matched=true;
      objects.put("Data", ((PushPattern)pattern).getDataType());
    }
    if (!_matched) {
      if (pattern instanceof EventPattern) {
        _matched=true;
        objects.put("Activation", ((EventPattern)pattern).getActivationType());
        objects.put("Event", ((EventPattern)pattern).getEventType());
      }
    }
    if (!_matched) {
      if (pattern instanceof SendPattern) {
        _matched=true;
        objects.put("Data", ((SendPattern)pattern).getDataType());
      }
    }
    return objects;
  }
  
  protected Map<String, CommunicationObject> _getCommunicationObjects(final RequestPort port) {
    final HashMap<String, CommunicationObject> objects = new HashMap<String, CommunicationObject>();
    final CommunicationPattern pattern = this.getPattern(port);
    boolean _matched = false;
    if (pattern instanceof QueryPattern) {
      _matched=true;
      objects.put("Request", ((QueryPattern)pattern).getRequestType());
      objects.put("Answer", ((QueryPattern)pattern).getAnswerType());
    }
    return objects;
  }
  
  protected Map<String, CommunicationObject> _getCommunicationObjects(final AnswerPort port) {
    final HashMap<String, CommunicationObject> objects = new HashMap<String, CommunicationObject>();
    final CommunicationPattern pattern = this.getPattern(port);
    boolean _matched = false;
    if (pattern instanceof QueryPattern) {
      _matched=true;
      objects.put("Request", ((QueryPattern)pattern).getRequestType());
      objects.put("Answer", ((QueryPattern)pattern).getAnswerType());
    }
    return objects;
  }
  
  public String getSourceMainMethod(final ComponentPort port) {
    String _xblockexpression = null;
    {
      final CommunicationPattern pattern = this.getPattern(port);
      String _switchResult = null;
      boolean _matched = false;
      if (pattern instanceof PushPattern) {
        _matched=true;
        _switchResult = "put";
      }
      if (!_matched) {
        if (pattern instanceof EventPattern) {
          _matched=true;
          _switchResult = "put";
        }
      }
      if (!_matched) {
        if (pattern instanceof SendPattern) {
          _matched=true;
          _switchResult = "send";
        }
      }
      if (!_matched) {
        if (pattern instanceof QueryPattern) {
          _matched=true;
          _switchResult = "query";
        }
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
  
  public String getCommObjectsParameterList(final OutputPort port) {
    String result = "";
    final Set<Map.Entry<String, CommunicationObject>> entrySet = this.getCommunicationObjects(port).entrySet();
    for (final Map.Entry<String, CommunicationObject> obj : entrySet) {
      {
        Map.Entry<String, CommunicationObject> _head = IterableExtensions.<Map.Entry<String, CommunicationObject>>head(entrySet);
        boolean _tripleNotEquals = (obj != _head);
        if (_tripleNotEquals) {
          String _result = result;
          result = (_result + ", ");
        }
        String _result_1 = result;
        CharSequence _fullyQualifiedNameCpp = this.comm.getFullyQualifiedNameCpp(obj.getValue());
        String _plus = (_fullyQualifiedNameCpp + " &");
        String _nameInstance = this.nameInstance(port);
        String _plus_1 = (_plus + _nameInstance);
        String _key = obj.getKey();
        String _plus_2 = (_plus_1 + _key);
        String _plus_3 = (_plus_2 + "Object");
        result = (_result_1 + _plus_3);
      }
    }
    return result;
  }
  
  public String getCommObjectsParameterList(final InputPort port) {
    String result = "";
    final CommunicationPattern pattern = this.getPattern(port);
    boolean _matched = false;
    if (pattern instanceof PushPattern) {
      _matched=true;
      CharSequence _fullyQualifiedNameCpp = this.comm.getFullyQualifiedNameCpp(((PushPattern)pattern).getDataType());
      String _plus = ("const " + _fullyQualifiedNameCpp);
      String _plus_1 = (_plus + " &");
      String _nameInstance = this.nameInstance(port);
      String _plus_2 = (_plus_1 + _nameInstance);
      String _plus_3 = (_plus_2 + "DataObject");
      result = _plus_3;
    }
    if (!_matched) {
      if (pattern instanceof SendPattern) {
        _matched=true;
        CharSequence _fullyQualifiedNameCpp = this.comm.getFullyQualifiedNameCpp(((SendPattern)pattern).getDataType());
        String _plus = ("const " + _fullyQualifiedNameCpp);
        String _plus_1 = (_plus + " &");
        String _nameInstance = this.nameInstance(port);
        String _plus_2 = (_plus_1 + _nameInstance);
        String _plus_3 = (_plus_2 + "DataObject");
        result = _plus_3;
      }
    }
    if (!_matched) {
      if (pattern instanceof QueryPattern) {
        _matched=true;
        CharSequence _fullyQualifiedNameCpp = this.comm.getFullyQualifiedNameCpp(((QueryPattern)pattern).getRequestType());
        String _plus = ("const " + _fullyQualifiedNameCpp);
        String _plus_1 = (_plus + " &");
        String _nameInstance = this.nameInstance(port);
        String _plus_2 = (_plus_1 + _nameInstance);
        String _name = ((QueryPattern)pattern).getRequestType().getName();
        String _plus_3 = (_plus_2 + _name);
        String _plus_4 = (_plus_3 + "RequestObject, ");
        result = _plus_4;
        String _result = result;
        CharSequence _fullyQualifiedNameCpp_1 = this.comm.getFullyQualifiedNameCpp(((QueryPattern)pattern).getAnswerType());
        String _plus_5 = ("const " + _fullyQualifiedNameCpp_1);
        String _plus_6 = (_plus_5 + " &");
        String _nameInstance_1 = this.nameInstance(port);
        String _plus_7 = (_plus_6 + _nameInstance_1);
        String _name_1 = ((QueryPattern)pattern).getAnswerType().getName();
        String _plus_8 = (_plus_7 + _name_1);
        String _plus_9 = (_plus_8 + "AnswerObject");
        result = (_result + _plus_9);
      }
    }
    if (!_matched) {
      if (pattern instanceof EventPattern) {
        _matched=true;
        CharSequence _fullyQualifiedNameCpp = this.comm.getFullyQualifiedNameCpp(((EventPattern)pattern).getActivationType());
        String _plus = (_fullyQualifiedNameCpp + " &parameter, ");
        result = _plus;
        String _result = result;
        CharSequence _fullyQualifiedNameCpp_1 = this.comm.getFullyQualifiedNameCpp(((EventPattern)pattern).getEventType());
        String _plus_1 = (_fullyQualifiedNameCpp_1 + " &event, ");
        result = (_result + _plus_1);
        String _result_1 = result;
        CharSequence _fullyQualifiedNameCpp_2 = this.comm.getFullyQualifiedNameCpp(((EventPattern)pattern).getEventStateType());
        String _plus_2 = ("const " + _fullyQualifiedNameCpp_2);
        String _plus_3 = (_plus_2 + " &state");
        result = (_result_1 + _plus_3);
      }
    }
    return result;
  }
  
  public String getCommObjectsCallerList(final ComponentPort port) {
    String result = "";
    final Set<Map.Entry<String, CommunicationObject>> entrySet = this.getCommunicationObjects(port).entrySet();
    for (final Map.Entry<String, CommunicationObject> obj : entrySet) {
      {
        Map.Entry<String, CommunicationObject> _head = IterableExtensions.<Map.Entry<String, CommunicationObject>>head(entrySet);
        boolean _tripleNotEquals = (obj != _head);
        if (_tripleNotEquals) {
          String _result = result;
          result = (_result + ", ");
        }
        String _result_1 = result;
        String _nameInstance = this.nameInstance(port);
        String _key = obj.getKey();
        String _plus = (_nameInstance + _key);
        String _plus_1 = (_plus + "Object");
        result = (_result_1 + _plus_1);
      }
    }
    return result;
  }
  
  public HashSet<CommObjectsRepository> getReferencedCommObjRepos(final Collection<CommunicationObject> comms) {
    HashSet<CommObjectsRepository> repoNames = new HashSet<CommObjectsRepository>();
    for (final CommunicationObject co : comms) {
      EObject _eContainer = co.eContainer();
      repoNames.add(((CommObjectsRepository) _eContainer));
    }
    return repoNames;
  }
  
  public HashSet<ComponentPort> getAllClientPorts(final ComponentDefinition comp) {
    final HashSet<ComponentPort> clients = new HashSet<ComponentPort>();
    final Function1<InputPort, Boolean> _function = (InputPort it) -> {
      OneWayCommunicationService _service = it.getService();
      return Boolean.valueOf((_service instanceof ForkingServiceDefinition));
    };
    Iterables.<ComponentPort>addAll(clients, IterableExtensions.<InputPort>filter(Iterables.<InputPort>filter(comp.getElements(), InputPort.class), _function));
    Iterables.<ComponentPort>addAll(clients, Iterables.<RequestPort>filter(comp.getElements(), RequestPort.class));
    final Function1<OutputPort, Boolean> _function_1 = (OutputPort it) -> {
      OneWayCommunicationService _service = it.getService();
      return Boolean.valueOf((_service instanceof JoiningServiceDefinition));
    };
    Iterables.<ComponentPort>addAll(clients, IterableExtensions.<OutputPort>filter(Iterables.<OutputPort>filter(comp.getElements(), OutputPort.class), _function_1));
    return clients;
  }
  
  public boolean isSubscriber(final ComponentPort svc) {
    if ((svc instanceof InputPort)) {
      final OneWayCommunicationService sdef = ((InputPort)svc).getService();
      if ((sdef instanceof ForkingServiceDefinition)) {
        ForkingPattern _pattern = ((ForkingServiceDefinition)sdef).getPattern();
        if ((_pattern instanceof PushPattern)) {
          return true;
        }
      }
    }
    return false;
  }
  
  public Iterable<InputPort> getAllPushClients(final ComponentDefinition comp) {
    final Function1<InputPort, Boolean> _function = (InputPort it) -> {
      CommunicationPattern _pattern = this.getPattern(it);
      return Boolean.valueOf((_pattern instanceof PushPattern));
    };
    return IterableExtensions.<InputPort>filter(Iterables.<InputPort>filter(comp.getElements(), InputPort.class), _function);
  }
  
  public HashSet<ComponentPort> getAllServerPorts(final ComponentDefinition comp) {
    final HashSet<ComponentPort> servers = new HashSet<ComponentPort>();
    final Function1<InputPort, Boolean> _function = (InputPort it) -> {
      OneWayCommunicationService _service = it.getService();
      return Boolean.valueOf((_service instanceof JoiningServiceDefinition));
    };
    Iterables.<ComponentPort>addAll(servers, IterableExtensions.<InputPort>filter(Iterables.<InputPort>filter(comp.getElements(), InputPort.class), _function));
    Iterables.<ComponentPort>addAll(servers, Iterables.<AnswerPort>filter(comp.getElements(), AnswerPort.class));
    final Function1<OutputPort, Boolean> _function_1 = (OutputPort it) -> {
      OneWayCommunicationService _service = it.getService();
      return Boolean.valueOf((_service instanceof ForkingServiceDefinition));
    };
    Iterables.<ComponentPort>addAll(servers, IterableExtensions.<OutputPort>filter(Iterables.<OutputPort>filter(comp.getElements(), OutputPort.class), _function_1));
    return servers;
  }
  
  public String getDefaultMiddlewareString(final ComponentPort port) {
    Iterable<SupportedMiddleware> _filter = Iterables.<SupportedMiddleware>filter(port.getExtensions(), SupportedMiddleware.class);
    for (final SupportedMiddleware mw : _filter) {
      boolean _isDefault = mw.isDefault();
      if (_isDefault) {
        return mw.getMiddleware().eClass().getName();
      }
    }
    return ACE_SmartSoft.class.getSimpleName();
  }
  
  public Collection<ComponentGeneratorExtension> getComponentGeneratorExtensions() {
    try {
      final ArrayList<ComponentGeneratorExtension> result = new ArrayList<ComponentGeneratorExtension>();
      final IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.smartmdsd.xtend.smartsoft.generator.ComponentGeneratorExtension");
      for (final IConfigurationElement ext : config) {
        {
          final Object obj = ext.createExecutableExtension("class");
          if ((obj instanceof ComponentGeneratorExtension)) {
            result.add(((ComponentGeneratorExtension)obj));
          }
        }
      }
      return result;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public Collection<ActivityGeneratorExtension> getActivityGeneratorExtensions() {
    try {
      final ArrayList<ActivityGeneratorExtension> result = new ArrayList<ActivityGeneratorExtension>();
      final IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.smartmdsd.xtend.smartsoft.generator.ComponentGeneratorExtension");
      for (final IConfigurationElement ext : config) {
        {
          final Object obj = ext.createExecutableExtension("class");
          if ((obj instanceof ActivityGeneratorExtension)) {
            result.add(((ActivityGeneratorExtension)obj));
          }
        }
      }
      return result;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public String getPortDefinition(final ComponentPort port) {
    if (port instanceof AnswerPort) {
      return _getPortDefinition((AnswerPort)port);
    } else if (port instanceof InputPort) {
      return _getPortDefinition((InputPort)port);
    } else if (port instanceof OutputPort) {
      return _getPortDefinition((OutputPort)port);
    } else if (port instanceof RequestPort) {
      return _getPortDefinition((RequestPort)port);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(port).toString());
    }
  }
  
  public String getPortImplementation(final ComponentPort port) {
    if (port instanceof AnswerPort) {
      return _getPortImplementation((AnswerPort)port);
    } else if (port instanceof InputPort) {
      return _getPortImplementation((InputPort)port);
    } else if (port instanceof OutputPort) {
      return _getPortImplementation((OutputPort)port);
    } else if (port instanceof RequestPort) {
      return _getPortImplementation((RequestPort)port);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(port).toString());
    }
  }
  
  public Map<String, CommunicationObject> getCommunicationObjects(final ComponentPort port) {
    if (port instanceof AnswerPort) {
      return _getCommunicationObjects((AnswerPort)port);
    } else if (port instanceof InputPort) {
      return _getCommunicationObjects((InputPort)port);
    } else if (port instanceof OutputPort) {
      return _getCommunicationObjects((OutputPort)port);
    } else if (port instanceof RequestPort) {
      return _getCommunicationObjects((RequestPort)port);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(port).toString());
    }
  }
}
