/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.system.datasheetPropertyChecks.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.SystemComponentArchitecture;
import org.eclipse.smartmdsd.ecore.system.datasheetPropertyChecks.DatasheetPropertyCheck;
import org.eclipse.smartmdsd.ecore.system.datasheetPropertyChecks.DatasheetPropertyChecksPackage;
import org.eclipse.smartmdsd.ecore.system.datasheetPropertyChecks.EvaluationFunction;
import org.eclipse.smartmdsd.ecore.system.datasheetPropertyChecks.EvaluationOperator;
import org.eclipse.smartmdsd.ecore.system.datasheetPropertyChecks.SystemDatasheetPropertyChecksModel;
import org.eclipse.smartmdsd.xtext.system.datasheetPropertyChecks.validation.AbstractSystemDatasheetPropertyChecksValidator;
import org.eclipse.smartmdsd.xtext.system.datasheetPropertyChecks.validation.DatasheetPropertyCheckEvaluator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class SystemDatasheetPropertyChecksValidator
extends AbstractSystemDatasheetPropertyChecksValidator {
    @Inject
    private DatasheetPropertyCheckEvaluator evaluator;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Check
    public void evaluateDatasheetPropertyCheck(DatasheetPropertyCheck check) {
        EObject parent = check.eContainer();
        if (!(parent instanceof SystemDatasheetPropertyChecksModel)) return;
        SystemComponentArchitecture system = ((SystemDatasheetPropertyChecksModel)parent).getSystem();
        if (system == null) return;
        if (check.getPropertyValue() == null) return;
        EvaluationFunction _function = check.getFunction();
        boolean _equals = Objects.equal((Object)_function, (Object)EvaluationFunction.FOR_ALL);
        if (_equals) {
            EList _components = system.getComponents();
            for (ComponentInstance instance : _components) {
                Collection<String> _incompatiblePropertyValues = this.evaluator.getIncompatiblePropertyValues(instance, check);
                for (String value : _incompatiblePropertyValues) {
                    String _name = instance.getName();
                    String _plus = "Component " + _name;
                    String _plus_1 = String.valueOf(_plus) + " has incompatible ";
                    String _propertyName = check.getPropertyName();
                    String _plus_2 = String.valueOf(_plus_1) + _propertyName;
                    String _plus_3 = String.valueOf(_plus_2) + " ";
                    String message = String.valueOf(_plus_3) + value;
                    this.warning(message, (EStructuralFeature)DatasheetPropertyChecksPackage.Literals.DATASHEET_PROPERTY_CHECK__PROPERTY_NAME);
                }
            }
            return;
        } else {
            EvaluationFunction _function_1 = check.getFunction();
            boolean _equals_1 = Objects.equal((Object)_function_1, (Object)EvaluationFunction.EXISTS);
            if (_equals_1) {
                boolean _exists = this.evaluator.exists(system, check);
                if (_exists) {
                    return;
                }
                boolean bl = true;
                boolean _not = bl;
                if (!_not) return;
                this.warning("No components found that satisfy this constraint", (EStructuralFeature)DatasheetPropertyChecksPackage.Literals.DATASHEET_PROPERTY_CHECK__PROPERTY_NAME);
                return;
            } else {
                EvaluationFunction _function_2 = check.getFunction();
                boolean _equals_2 = Objects.equal((Object)_function_2, (Object)EvaluationFunction.SUM);
                if (!_equals_2) return;
                double left = this.evaluator.calculateSum(system, check.getPropertyName());
                try {
                    Double right = Double.valueOf(check.getPropertyValue());
                    boolean _doubleCompare = this.evaluator.doubleCompare(left, check.getOperator(), right);
                    if (_doubleCompare) {
                        return;
                    }
                    boolean bl = true;
                    boolean _not_1 = bl;
                    if (!_not_1) return;
                    EvaluationOperator _operator = check.getOperator();
                    String _plus = "Sum constraint violation: \u03a3 " + Double.valueOf(left) + " " + _operator;
                    String _plus_1 = String.valueOf(_plus) + " ";
                    String message_1 = String.valueOf(_plus_1) + right;
                    this.warning(message_1, (EStructuralFeature)DatasheetPropertyChecksPackage.Literals.DATASHEET_PROPERTY_CHECK__PROPERTY_NAME);
                    return;
                }
                catch (Throwable _t) {
                    if (!(_t instanceof NumberFormatException)) throw Exceptions.sneakyThrow((Throwable)_t);
                    NumberFormatException ex = (NumberFormatException)_t;
                    ex.printStackTrace();
                    return;
                }
            }
        }
    }
}

