/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.targetPlatform.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.AbstractTPElement;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.AbstractTPSubNode;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.NetworkConnection;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.OperatingSystem;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.TargetPlatformDefinition;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.TargetPlatformModel;
import org.eclipse.smartmdsd.xtext.service.roboticMiddleware.formatting2.RoboticMiddlewareFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class TargetPlatformFormatter extends RoboticMiddlewareFormatter {
  protected void _format(final TargetPlatformModel targetPlatformModel, @Extension final IFormattableDocument document) {
    final ISemanticRegion ropen = this.textRegionExtensions.regionFor(targetPlatformModel).keyword("{");
    final ISemanticRegion rclose = this.textRegionExtensions.regionFor(targetPlatformModel).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(ropen, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(ropen, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(ropen, rclose, _function_2);
    EList<AbstractTPElement> _elements = targetPlatformModel.getElements();
    for (final AbstractTPElement abstractPlatformElement : _elements) {
      document.<AbstractTPElement>format(abstractPlatformElement);
    }
  }
  
  protected void _format(final TargetPlatformDefinition platform, @Extension final IFormattableDocument document) {
    OperatingSystem _os = platform.getOs();
    if (_os!=null) {
      document.<OperatingSystem>format(_os);
    }
    OperatingSystem _os_1 = platform.getOs();
    if (_os_1!=null) {
      final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
        it.newLine();
      };
      document.<OperatingSystem>append(_os_1, _function);
    }
    final ISemanticRegion ropen = this.textRegionExtensions.regionFor(platform).keyword("{");
    final ISemanticRegion rclose = this.textRegionExtensions.regionFor(platform).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(ropen, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(ropen, _function_2);
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(ropen, rclose, _function_3);
    EList<AbstractTPSubNode> _elements = platform.getElements();
    for (final AbstractTPSubNode elem : _elements) {
      {
        document.<AbstractTPSubNode>format(elem);
        final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
          it.setNewLines(1, 1, 2);
        };
        document.<AbstractTPSubNode>append(elem, _function_4);
      }
    }
  }
  
  protected void _format(final NetworkConnection connection, @Extension final IFormattableDocument document) {
    final ISemanticRegion ropen = this.textRegionExtensions.regionFor(connection).keyword("{");
    final ISemanticRegion rclose = this.textRegionExtensions.regionFor(connection).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(ropen, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(ropen, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(ropen, rclose, _function_2);
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.setNewLines(1, 1, 2);
    };
    document.<NetworkConnection>append(connection, _function_3);
  }
  
  public void format(final Object connection, final IFormattableDocument document) {
    if (connection instanceof NetworkConnection) {
      _format((NetworkConnection)connection, document);
      return;
    } else if (connection instanceof TargetPlatformDefinition) {
      _format((TargetPlatformDefinition)connection, document);
      return;
    } else if (connection instanceof XtextResource) {
      _format((XtextResource)connection, document);
      return;
    } else if (connection instanceof TargetPlatformModel) {
      _format((TargetPlatformModel)connection, document);
      return;
    } else if (connection instanceof EObject) {
      _format((EObject)connection, document);
      return;
    } else if (connection == null) {
      _format((Void)null, document);
      return;
    } else if (connection != null) {
      _format(connection, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(connection, document).toString());
    }
  }
}
