/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.smartmdsd.ui.natures.SmartMDSDNatureEnum;
import org.eclipse.smartmdsd.ui.wizards.AbstractProjectCreationWizard;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class WizardNewBehaviorProject
extends AbstractProjectCreationWizard {
    public static final String WIZARD_ID = "org.eclipse.smartmdsd.ui.wizards.behavior";

    public WizardNewBehaviorProject() {
        super("New Behavior Project (Tier 3)");
    }

    @Override
    protected WizardNewProjectCreationPage createFirstPage() {
        WizardNewProjectCreationPage page = new WizardNewProjectCreationPage("BehaviorWizard");
        page.setTitle("Behavior Project (Tier 3)");
        page.setDescription("This wizard creates a Behavior project with the focus on behavior task models.");
        page.setInitialProjectName("BehaviorAnyName");
        return page;
    }

    @Override
    protected boolean isModelingProject() {
        return false;
    }

    @Override
    protected void customizeProject(IProject project, IFolder modelFolder, IProgressMonitor monitor) throws CoreException {
        IFolder smartsoft = project.getFolder("smartsoft");
        smartsoft.create(true, true, monitor);
        IFile cmake = smartsoft.getFile("CMakeLists.txt");
        String cmake_string = "cmake_minimum_required(VERSION 3.5)\nproject(" + project.getName() + ")";
        cmake.create((InputStream)new ByteArrayInputStream(cmake_string.getBytes()), true, monitor);
    }

    @Override
    protected SmartMDSDNatureEnum getCurrentNatureEnum() {
        return SmartMDSDNatureEnum.BehaviorNature;
    }
}

