/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ecore.system.componentArchitecture;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommunicationServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ForkingServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.JoiningServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.OneWayCommunicationService;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ServiceInstance;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ComponentArchitectureModelUtility
extends ComponentDefinitionModelUtility {
    public static boolean servicePortsCompatible(ServiceInstance left, ServiceInstance right) {
        ComponentPort _port_1;
        boolean _notEquals;
        ComponentPort _port = left.getPort();
        boolean bl = _notEquals = !Objects.equal((Object)_port, (Object)(_port_1 = right.getPort()));
        if (_notEquals) {
            CommunicationServiceDefinition _service = ComponentDefinitionModelUtility.getService((ComponentPort)left.getPort());
            CommunicationServiceDefinition _service_1 = ComponentDefinitionModelUtility.getService((ComponentPort)right.getPort());
            return Objects.equal((Object)_service, (Object)_service_1);
        }
        return false;
    }

    public static Iterable<ComponentPort> getAllClientPorts(ComponentInstance instance) {
        ArrayList services = CollectionLiterals.newArrayList();
        Functions.Function1 _function = it -> {
            OneWayCommunicationService _service = it.getService();
            return _service instanceof ForkingServiceDefinition;
        };
        Iterables.addAll((Collection)services, (Iterable)IterableExtensions.filter((Iterable)ComponentDefinitionModelUtility.getInputPorts((ComponentDefinition)instance.getComponent()), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> {
            OneWayCommunicationService _service = it.getService();
            return _service instanceof JoiningServiceDefinition;
        };
        Iterables.addAll((Collection)services, (Iterable)IterableExtensions.filter((Iterable)ComponentDefinitionModelUtility.getOutputPorts((ComponentDefinition)instance.getComponent()), (Functions.Function1)_function_1));
        Iterables.addAll((Collection)services, (Iterable)ComponentDefinitionModelUtility.getRequestPorts((ComponentDefinition)instance.getComponent()));
        return services;
    }

    public static Iterable<ComponentPort> getNonOptionalClientPorts(ComponentInstance instance) {
        ArrayList services = CollectionLiterals.newArrayList();
        Functions.Function1 _function = it -> {
            OneWayCommunicationService _service = it.getService();
            return _service instanceof ForkingServiceDefinition;
        };
        Iterables.addAll((Collection)services, (Iterable)IterableExtensions.filter((Iterable)ComponentDefinitionModelUtility.getInputPorts((ComponentDefinition)instance.getComponent()), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> {
            OneWayCommunicationService _service = it.getService();
            return _service instanceof JoiningServiceDefinition;
        };
        Iterables.addAll((Collection)services, (Iterable)IterableExtensions.filter((Iterable)ComponentDefinitionModelUtility.getOutputPorts((ComponentDefinition)instance.getComponent()), (Functions.Function1)_function_1));
        Iterables.addAll((Collection)services, (Iterable)ComponentDefinitionModelUtility.getRequestPorts((ComponentDefinition)instance.getComponent()));
        return services;
    }

    public static Iterable<ComponentPort> getAllServerPorts(ComponentInstance instance) {
        ArrayList services = CollectionLiterals.newArrayList();
        Functions.Function1 _function = it -> {
            OneWayCommunicationService _service = it.getService();
            return _service instanceof ForkingServiceDefinition;
        };
        Iterables.addAll((Collection)services, (Iterable)IterableExtensions.filter((Iterable)ComponentDefinitionModelUtility.getOutputPorts((ComponentDefinition)instance.getComponent()), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> {
            OneWayCommunicationService _service = it.getService();
            return _service instanceof JoiningServiceDefinition;
        };
        Iterables.addAll((Collection)services, (Iterable)IterableExtensions.filter((Iterable)ComponentDefinitionModelUtility.getInputPorts((ComponentDefinition)instance.getComponent()), (Functions.Function1)_function_1));
        Iterables.addAll((Collection)services, (Iterable)ComponentDefinitionModelUtility.getAnswerPorts((ComponentDefinition)instance.getComponent()));
        return services;
    }
}

