/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *  
 * SPDX-License-Identifier: EPL-2.0
 *  
 * Contributors:
 *    Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.base.genericDatasheet;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Technology Readiness Level</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.smartmdsd.ecore.base.genericDatasheet.GenericDatasheetPackage#getTechnologyReadinessLevel()
 * @model
 * @generated
 */
public enum TechnologyReadinessLevel implements Enumerator {
	/**
	 * The '<em><b>TRL1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRL1_VALUE
	 * @generated
	 * @ordered
	 */
	TRL1(0, "TRL1", "TRL1"),

	/**
	 * The '<em><b>TRL2</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRL2_VALUE
	 * @generated
	 * @ordered
	 */
	TRL2(1, "TRL2", "TRL2"),

	/**
	 * The '<em><b>TRL3</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRL3_VALUE
	 * @generated
	 * @ordered
	 */
	TRL3(2, "TRL3", "TRL3"),

	/**
	 * The '<em><b>TRL4</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRL4_VALUE
	 * @generated
	 * @ordered
	 */
	TRL4(3, "TRL4", "TRL4"),

	/**
	 * The '<em><b>TRL5</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRL5_VALUE
	 * @generated
	 * @ordered
	 */
	TRL5(4, "TRL5", "TRL5"),

	/**
	 * The '<em><b>TRL6</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRL6_VALUE
	 * @generated
	 * @ordered
	 */
	TRL6(5, "TRL6", "TRL6"),

	/**
	 * The '<em><b>TRL7</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRL7_VALUE
	 * @generated
	 * @ordered
	 */
	TRL7(6, "TRL7", "TRL7"),

	/**
	 * The '<em><b>TRL8</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRL8_VALUE
	 * @generated
	 * @ordered
	 */
	TRL8(7, "TRL8", "TRL8"),

	/**
	 * The '<em><b>TRL9</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRL9_VALUE
	 * @generated
	 * @ordered
	 */
	TRL9(8, "TRL9", "TRL9");

	/**
	 * The '<em><b>TRL1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRL1
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int TRL1_VALUE = 0;

	/**
	 * The '<em><b>TRL2</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRL2
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int TRL2_VALUE = 1;

	/**
	 * The '<em><b>TRL3</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRL3
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int TRL3_VALUE = 2;

	/**
	 * The '<em><b>TRL4</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRL4
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int TRL4_VALUE = 3;

	/**
	 * The '<em><b>TRL5</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRL5
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int TRL5_VALUE = 4;

	/**
	 * The '<em><b>TRL6</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRL6
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int TRL6_VALUE = 5;

	/**
	 * The '<em><b>TRL7</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRL7
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int TRL7_VALUE = 6;

	/**
	 * The '<em><b>TRL8</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRL8
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int TRL8_VALUE = 7;

	/**
	 * The '<em><b>TRL9</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRL9
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int TRL9_VALUE = 8;

	/**
	 * An array of all the '<em><b>Technology Readiness Level</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final TechnologyReadinessLevel[] VALUES_ARRAY = new TechnologyReadinessLevel[] { TRL1, TRL2, TRL3,
			TRL4, TRL5, TRL6, TRL7, TRL8, TRL9, };

	/**
	 * A public read-only list of all the '<em><b>Technology Readiness Level</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<TechnologyReadinessLevel> VALUES = Collections
			.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Technology Readiness Level</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static TechnologyReadinessLevel get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			TechnologyReadinessLevel result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Technology Readiness Level</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static TechnologyReadinessLevel getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			TechnologyReadinessLevel result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Technology Readiness Level</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static TechnologyReadinessLevel get(int value) {
		switch (value) {
		case TRL1_VALUE:
			return TRL1;
		case TRL2_VALUE:
			return TRL2;
		case TRL3_VALUE:
			return TRL3;
		case TRL4_VALUE:
			return TRL4;
		case TRL5_VALUE:
			return TRL5;
		case TRL6_VALUE:
			return TRL6;
		case TRL7_VALUE:
			return TRL7;
		case TRL8_VALUE:
			return TRL8;
		case TRL9_VALUE:
			return TRL9;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private TechnologyReadinessLevel(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
		return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}

} //TechnologyReadinessLevel
