/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.service.communicationPattern;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.CommunicationPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.EventPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.PushPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.QueryPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.SendPattern;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;

@SuppressWarnings("all")
public class CommunicationPatternModelUtility {
  public static Collection<CommunicationObject> getAllCommObjects(final CommunicationPattern pattern) {
    final HashSet<CommunicationObject> objects = new HashSet<CommunicationObject>();
    boolean _matched = false;
    if (pattern instanceof PushPattern) {
      _matched=true;
      objects.add(((PushPattern)pattern).getDataType());
    }
    if (!_matched) {
      if (pattern instanceof SendPattern) {
        _matched=true;
        objects.add(((SendPattern)pattern).getDataType());
      }
    }
    if (!_matched) {
      if (pattern instanceof QueryPattern) {
        _matched=true;
        CollectionExtensions.<CommunicationObject>addAll(objects, ((QueryPattern)pattern).getRequestType(), ((QueryPattern)pattern).getAnswerType());
      }
    }
    if (!_matched) {
      if (pattern instanceof EventPattern) {
        _matched=true;
        CollectionExtensions.<CommunicationObject>addAll(objects, ((EventPattern)pattern).getEventType(), ((EventPattern)pattern).getActivationType(), ((EventPattern)pattern).getEventStateType());
      }
    }
    return objects;
  }
}
