/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.service.parameterDefinition;

import com.google.common.collect.Iterables;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesModelUtility;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.AbstractParameter;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterDefinition;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterSetDefinition;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.TriggerDefinition;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class ParameterDefinitionModelUtility extends BasicAttributesModelUtility {
  public Iterable<ParameterDefinition> getParameters(final ParameterSetDefinition set) {
    return Iterables.<ParameterDefinition>filter(set.getParameters(), ParameterDefinition.class);
  }
  
  public Iterable<TriggerDefinition> getTriggers(final ParameterSetDefinition set) {
    return Iterables.<TriggerDefinition>filter(set.getParameters(), TriggerDefinition.class);
  }
  
  /**
   * Iterate over the extends ParameterSets and return the result as a HashSet
   */
  public LinkedHashSet<ParameterSetDefinition> getParameterSetHierarchy(final ParameterSetDefinition set) {
    return this.iterateParameterSetHierarchy(set, CollectionLiterals.<ParameterSetDefinition>newLinkedHashSet());
  }
  
  public Iterable<ParameterDefinition> getParameterHierarchy(final ParameterSetDefinition set) {
    final Function1<ParameterSetDefinition, EList<AbstractParameter>> _function = (ParameterSetDefinition it) -> {
      return it.getParameters();
    };
    return Iterables.<ParameterDefinition>filter((Iterables.<AbstractParameter>concat(IterableExtensions.<ParameterSetDefinition, EList<AbstractParameter>>map(this.getParameterSetHierarchy(set), _function))), ParameterDefinition.class);
  }
  
  public Iterable<TriggerDefinition> getTriggerHierarchy(final ParameterSetDefinition set) {
    final Function1<ParameterSetDefinition, EList<AbstractParameter>> _function = (ParameterSetDefinition it) -> {
      return it.getParameters();
    };
    return Iterables.<TriggerDefinition>filter((Iterables.<AbstractParameter>concat(IterableExtensions.<ParameterSetDefinition, EList<AbstractParameter>>map(this.getParameterSetHierarchy(set), _function))), TriggerDefinition.class);
  }
  
  private LinkedHashSet<ParameterSetDefinition> iterateParameterSetHierarchy(final ParameterSetDefinition set, final LinkedHashSet<ParameterSetDefinition> visited) {
    EList<ParameterSetDefinition> _extends = set.getExtends();
    for (final ParameterSetDefinition next : _extends) {
      boolean _contains = visited.contains(next);
      boolean _not = (!_contains);
      if (_not) {
        visited.add(next);
        visited.addAll(this.iterateParameterSetHierarchy(next, visited));
      }
    }
    return visited;
  }
}
