/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *  
 * SPDX-License-Identifier: EPL-2.0
 *  
 * Contributors:
 *    Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.service.serviceDefinition.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.edit.domain.EditingDomain;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefinitionPackage;

import org.eclipse.smartmdsd.ecore.service.serviceDefinition.util.ServiceDefinitionAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ServiceDefinitionItemProviderAdapterFactory extends ServiceDefinitionAdapterFactory
		implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This helps manage the child creation extenders.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager(
			ServiceDefinitionEditPlugin.INSTANCE, ServiceDefinitionPackage.eNS_URI);

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ServiceDefinitionItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ServiceDefModelItemProvider serviceDefModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createServiceDefModelAdapter() {
		if (serviceDefModelItemProvider == null) {
			serviceDefModelItemProvider = new ServiceDefModelItemProvider(this);
		}

		return serviceDefModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefRepository} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ServiceDefRepositoryItemProvider serviceDefRepositoryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefRepository}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createServiceDefRepositoryAdapter() {
		if (serviceDefRepositoryItemProvider == null) {
			serviceDefRepositoryItemProvider = new ServiceDefRepositoryItemProvider(this);
		}

		return serviceDefRepositoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommRepoImport} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CommRepoImportItemProvider commRepoImportItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommRepoImport}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCommRepoImportAdapter() {
		if (commRepoImportItemProvider == null) {
			commRepoImportItemProvider = new CommRepoImportItemProvider(this);
		}

		return commRepoImportItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceRepoVersion} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ServiceRepoVersionItemProvider serviceRepoVersionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceRepoVersion}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createServiceRepoVersionAdapter() {
		if (serviceRepoVersionItemProvider == null) {
			serviceRepoVersionItemProvider = new ServiceRepoVersionItemProvider(this);
		}

		return serviceRepoVersionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceProperty} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ServicePropertyItemProvider servicePropertyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceProperty}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createServicePropertyAdapter() {
		if (servicePropertyItemProvider == null) {
			servicePropertyItemProvider = new ServicePropertyItemProvider(this);
		}

		return servicePropertyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.smartmdsd.ecore.service.serviceDefinition.CoordinationServiceDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CoordinationServiceDefinitionItemProvider coordinationServiceDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.smartmdsd.ecore.service.serviceDefinition.CoordinationServiceDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCoordinationServiceDefinitionAdapter() {
		if (coordinationServiceDefinitionItemProvider == null) {
			coordinationServiceDefinitionItemProvider = new CoordinationServiceDefinitionItemProvider(this);
		}

		return coordinationServiceDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.smartmdsd.ecore.service.serviceDefinition.ForkingServiceDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ForkingServiceDefinitionItemProvider forkingServiceDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.smartmdsd.ecore.service.serviceDefinition.ForkingServiceDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createForkingServiceDefinitionAdapter() {
		if (forkingServiceDefinitionItemProvider == null) {
			forkingServiceDefinitionItemProvider = new ForkingServiceDefinitionItemProvider(this);
		}

		return forkingServiceDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.smartmdsd.ecore.service.serviceDefinition.RequestAnswerServiceDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RequestAnswerServiceDefinitionItemProvider requestAnswerServiceDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.smartmdsd.ecore.service.serviceDefinition.RequestAnswerServiceDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRequestAnswerServiceDefinitionAdapter() {
		if (requestAnswerServiceDefinitionItemProvider == null) {
			requestAnswerServiceDefinitionItemProvider = new RequestAnswerServiceDefinitionItemProvider(this);
		}

		return requestAnswerServiceDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommunicationServiceUsage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CommunicationServiceUsageItemProvider communicationServiceUsageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommunicationServiceUsage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCommunicationServiceUsageAdapter() {
		if (communicationServiceUsageItemProvider == null) {
			communicationServiceUsageItemProvider = new CommunicationServiceUsageItemProvider(this);
		}

		return communicationServiceUsageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.smartmdsd.ecore.service.serviceDefinition.JoiningServiceDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JoiningServiceDefinitionItemProvider joiningServiceDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.smartmdsd.ecore.service.serviceDefinition.JoiningServiceDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJoiningServiceDefinitionAdapter() {
		if (joiningServiceDefinitionItemProvider == null) {
			joiningServiceDefinitionItemProvider = new JoiningServiceDefinitionItemProvider(this);
		}

		return joiningServiceDefinitionItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List<IChildCreationExtender> getChildCreationExtenders() {
		return childCreationExtenderManager.getChildCreationExtenders();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
		return childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return childCreationExtenderManager;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (serviceDefModelItemProvider != null)
			serviceDefModelItemProvider.dispose();
		if (serviceDefRepositoryItemProvider != null)
			serviceDefRepositoryItemProvider.dispose();
		if (commRepoImportItemProvider != null)
			commRepoImportItemProvider.dispose();
		if (serviceRepoVersionItemProvider != null)
			serviceRepoVersionItemProvider.dispose();
		if (servicePropertyItemProvider != null)
			servicePropertyItemProvider.dispose();
		if (coordinationServiceDefinitionItemProvider != null)
			coordinationServiceDefinitionItemProvider.dispose();
		if (forkingServiceDefinitionItemProvider != null)
			forkingServiceDefinitionItemProvider.dispose();
		if (requestAnswerServiceDefinitionItemProvider != null)
			requestAnswerServiceDefinitionItemProvider.dispose();
		if (communicationServiceUsageItemProvider != null)
			communicationServiceUsageItemProvider.dispose();
		if (joiningServiceDefinitionItemProvider != null)
			joiningServiceDefinitionItemProvider.dispose();
	}

}
