/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.service.serviceDefinition;

import java.util.Collection;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.CommunicationPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.CommunicationPatternModelUtility;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommunicationServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ForkingServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.JoiningServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.RequestAnswerServiceDefinition;

@SuppressWarnings("all")
public class ServiceDefinitionModelUtility extends CommunicationPatternModelUtility {
  public static Collection<CommunicationObject> getAllCommObjects(final CommunicationServiceDefinition service) {
    return CommunicationPatternModelUtility.getAllCommObjects(ServiceDefinitionModelUtility.getPattern(service));
  }
  
  public static CommunicationPattern getPattern(final CommunicationServiceDefinition service) {
    CommunicationPattern _switchResult = null;
    boolean _matched = false;
    if (service instanceof ForkingServiceDefinition) {
      _matched=true;
      _switchResult = ((ForkingServiceDefinition)service).getPattern();
    }
    if (!_matched) {
      if (service instanceof JoiningServiceDefinition) {
        _matched=true;
        _switchResult = ((JoiningServiceDefinition)service).getPattern();
      }
    }
    if (!_matched) {
      if (service instanceof RequestAnswerServiceDefinition) {
        _matched=true;
        _switchResult = ((RequestAnswerServiceDefinition)service).getPattern();
      }
    }
    return _switchResult;
  }
}
